/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.inappmessage;

import android.app.Activity;
import android.os.Build;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.window.OnBackInvokedCallback;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.braze.configuration.BrazeConfigurationProvider;
import com.braze.enums.inappmessage.DismissType;
import com.braze.enums.inappmessage.MessageType;
import com.braze.enums.inappmessage.SlideFrom;
import com.braze.models.inappmessage.IInAppMessage;
import com.braze.models.inappmessage.IInAppMessageImmersive;
import com.braze.models.inappmessage.InAppMessageSlideup;
import com.braze.models.inappmessage.MessageButton;
import com.braze.support.BrazeLogger;
import com.braze.ui.inappmessage.BrazeInAppMessageManager;
import com.braze.ui.inappmessage.DefaultInAppMessageViewWrapper;
import com.braze.ui.inappmessage.IInAppMessageViewWrapper;
import com.braze.ui.inappmessage.InAppMessageCloser;
import com.braze.ui.inappmessage.listeners.IInAppMessageViewLifecycleListener;
import com.braze.ui.inappmessage.listeners.SwipeDismissTouchListener;
import com.braze.ui.inappmessage.listeners.TouchAwareSwipeDismissTouchListener;
import com.braze.ui.inappmessage.utils.InAppMessageViewUtils;
import com.braze.ui.inappmessage.views.IInAppMessageImmersiveView;
import com.braze.ui.inappmessage.views.IInAppMessageView;
import com.braze.ui.inappmessage.views.InAppMessageHtmlBaseView;
import com.braze.ui.support.ViewUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 d2\u00020\u0001:\u0001dBc\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0003\u0012\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000f\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0011J\b\u0010H\u001a\u00020IH\u0016J(\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020!2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010L\u001a\u00020I2\n\b\u0002\u0010M\u001a\u0004\u0018\u00010NH\u0016J\b\u0010O\u001a\u00020IH\u0016J\b\u0010P\u001a\u00020IH\u0016J\u0010\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u000208H\u0016J\b\u0010T\u001a\u00020IH\u0016J\b\u0010U\u001a\u00020VH\u0016J\b\u0010W\u001a\u00020VH\u0016J\b\u0010X\u001a\u00020YH\u0016J\b\u0010Z\u001a\u00020[H\u0016J \u0010\\\u001a\u00020I2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010]\u001a\u00020^2\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010_\u001a\u00020!2\u0006\u0010`\u001a\u00020aH\u0016J\u0010\u0010b\u001a\u00020I2\u0006\u0010`\u001a\u00020aH\u0016J\u0010\u0010c\u001a\u00020I2\u0006\u0010S\u001a\u000208H\u0016R\"\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0017\"\u0004\b\u001b\u0010\u0019R\u0016\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010'X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0096\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b0\u00101\u001a\u0004\b2\u00103R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u0010\u0017R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u001a\u00107\u001a\u000208X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00109\"\u0004\b:\u0010;R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010\u001dR\u001c\u0010=\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0017\"\u0004\b?\u0010\u0019R6\u0010@\u001a\u001e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020B0Aj\u000e\u0012\u0004\u0012\u00020B\u0012\u0004\u0012\u00020B`CX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010G\u00a8\u0006e"}, d2={"Lcom/braze/ui/inappmessage/DefaultInAppMessageViewWrapper;", "Lcom/braze/ui/inappmessage/IInAppMessageViewWrapper;", "inAppMessageView", "Landroid/view/View;", "inAppMessage", "Lcom/braze/models/inappmessage/IInAppMessage;", "inAppMessageViewLifecycleListener", "Lcom/braze/ui/inappmessage/listeners/IInAppMessageViewLifecycleListener;", "configurationProvider", "Lcom/braze/configuration/BrazeConfigurationProvider;", "openingAnimation", "Landroid/view/animation/Animation;", "closingAnimation", "clickableInAppMessageView", "buttonViews", "", "closeButton", "(Landroid/view/View;Lcom/braze/models/inappmessage/IInAppMessage;Lcom/braze/ui/inappmessage/listeners/IInAppMessageViewLifecycleListener;Lcom/braze/configuration/BrazeConfigurationProvider;Landroid/view/animation/Animation;Landroid/view/animation/Animation;Landroid/view/View;Ljava/util/List;Landroid/view/View;)V", "getButtonViews", "()Ljava/util/List;", "setButtonViews", "(Ljava/util/List;)V", "getClickableInAppMessageView", "()Landroid/view/View;", "setClickableInAppMessageView", "(Landroid/view/View;)V", "getCloseButton", "setCloseButton", "getClosingAnimation", "()Landroid/view/animation/Animation;", "getConfigurationProvider", "()Lcom/braze/configuration/BrazeConfigurationProvider;", "contentViewGroupParentLayout", "Landroid/view/ViewGroup;", "getContentViewGroupParentLayout", "()Landroid/view/ViewGroup;", "setContentViewGroupParentLayout", "(Landroid/view/ViewGroup;)V", "dismissRunnable", "Ljava/lang/Runnable;", "getDismissRunnable", "()Ljava/lang/Runnable;", "setDismissRunnable", "(Ljava/lang/Runnable;)V", "getInAppMessage", "()Lcom/braze/models/inappmessage/IInAppMessage;", "inAppMessageCloser", "Lcom/braze/ui/inappmessage/InAppMessageCloser;", "getInAppMessageCloser$annotations", "()V", "getInAppMessageCloser", "()Lcom/braze/ui/inappmessage/InAppMessageCloser;", "getInAppMessageView", "getInAppMessageViewLifecycleListener", "()Lcom/braze/ui/inappmessage/listeners/IInAppMessageViewLifecycleListener;", "isAnimatingClose", "", "()Z", "setAnimatingClose", "(Z)V", "getOpeningAnimation", "previouslyFocusedView", "getPreviouslyFocusedView", "setPreviouslyFocusedView", "viewAccessibilityFlagMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getViewAccessibilityFlagMap", "()Ljava/util/HashMap;", "setViewAccessibilityFlagMap", "(Ljava/util/HashMap;)V", "addDismissRunnable", "", "addInAppMessageViewToViewGroup", "parentViewGroup", "announceForAccessibilityIfNecessary", "fallbackAccessibilityMessage", "", "close", "closeInAppMessageView", "createAnimationListener", "Landroid/view/animation/Animation$AnimationListener;", "opening", "createButtonClickListeners", "createClickListener", "Landroid/view/View$OnClickListener;", "createCloseInAppMessageClickListener", "createDismissCallbacks", "Lcom/braze/ui/inappmessage/listeners/SwipeDismissTouchListener$DismissCallbacks;", "createTouchAwareListener", "Lcom/braze/ui/inappmessage/listeners/TouchAwareSwipeDismissTouchListener$ITouchListener;", "finalizeViewBeforeDisplay", "getLayoutParams", "Landroid/view/ViewGroup$LayoutParams;", "getParentViewGroup", "activity", "Landroid/app/Activity;", "open", "setAndStartAnimation", "Companion", "android-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nDefaultInAppMessageViewWrapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultInAppMessageViewWrapper.kt\ncom/braze/ui/inappmessage/DefaultInAppMessageViewWrapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,556:1\n1864#2,3:557\n*S KotlinDebug\n*F\n+ 1 DefaultInAppMessageViewWrapper.kt\ncom/braze/ui/inappmessage/DefaultInAppMessageViewWrapper\n*L\n328#1:557,3\n*E\n"})
public class DefaultInAppMessageViewWrapper
implements IInAppMessageViewWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final View inAppMessageView;
    @NotNull
    private final IInAppMessage inAppMessage;
    @NotNull
    private final IInAppMessageViewLifecycleListener inAppMessageViewLifecycleListener;
    @NotNull
    private final BrazeConfigurationProvider configurationProvider;
    @Nullable
    private final Animation openingAnimation;
    @Nullable
    private final Animation closingAnimation;
    @Nullable
    private View clickableInAppMessageView;
    @Nullable
    private List<? extends View> buttonViews;
    @Nullable
    private View closeButton;
    @NotNull
    private final InAppMessageCloser inAppMessageCloser;
    private boolean isAnimatingClose;
    @Nullable
    private Runnable dismissRunnable;
    @Nullable
    private View previouslyFocusedView;
    @NotNull
    private HashMap<Integer, Integer> viewAccessibilityFlagMap;
    @Nullable
    private ViewGroup contentViewGroupParentLayout;

    @JvmOverloads
    public DefaultInAppMessageViewWrapper(@NotNull View inAppMessageView, @NotNull IInAppMessage inAppMessage, @NotNull IInAppMessageViewLifecycleListener inAppMessageViewLifecycleListener, @NotNull BrazeConfigurationProvider configurationProvider, @Nullable Animation openingAnimation, @Nullable Animation closingAnimation, @Nullable View clickableInAppMessageView, @Nullable List<? extends View> buttonViews, @Nullable View closeButton) {
        Intrinsics.checkNotNullParameter((Object)inAppMessageView, (String)"inAppMessageView");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Intrinsics.checkNotNullParameter((Object)inAppMessageViewLifecycleListener, (String)"inAppMessageViewLifecycleListener");
        Intrinsics.checkNotNullParameter((Object)configurationProvider, (String)"configurationProvider");
        this.inAppMessageView = inAppMessageView;
        this.inAppMessage = inAppMessage;
        this.inAppMessageViewLifecycleListener = inAppMessageViewLifecycleListener;
        this.configurationProvider = configurationProvider;
        this.openingAnimation = openingAnimation;
        this.closingAnimation = closingAnimation;
        this.clickableInAppMessageView = clickableInAppMessageView;
        this.buttonViews = buttonViews;
        this.closeButton = closeButton;
        this.viewAccessibilityFlagMap = new HashMap();
        View view = this.getClickableInAppMessageView();
        if (view == null) {
            view = this.getInAppMessageView();
        }
        this.setClickableInAppMessageView(view);
        if (this.getInAppMessage() instanceof InAppMessageSlideup) {
            SwipeDismissTouchListener.DismissCallbacks dismissCallbacks = this.createDismissCallbacks();
            TouchAwareSwipeDismissTouchListener touchAwareSwipeListener = new TouchAwareSwipeDismissTouchListener(this.getInAppMessageView(), dismissCallbacks);
            touchAwareSwipeListener.setTouchListener(this.createTouchAwareListener());
            View view2 = this.getClickableInAppMessageView();
            if (view2 != null) {
                view2.setOnTouchListener((View.OnTouchListener)touchAwareSwipeListener);
            }
        }
        View view3 = this.getClickableInAppMessageView();
        if (view3 != null) {
            view3.setOnClickListener(this.createClickListener());
        }
        this.inAppMessageCloser = new InAppMessageCloser(this);
        View view4 = this.getCloseButton();
        if (view4 != null) {
            view4.setOnClickListener(this.createCloseInAppMessageClickListener());
        }
        this.createButtonClickListeners();
    }

    public /* synthetic */ DefaultInAppMessageViewWrapper(View view, IInAppMessage iInAppMessage, IInAppMessageViewLifecycleListener iInAppMessageViewLifecycleListener, BrazeConfigurationProvider brazeConfigurationProvider, Animation animation, Animation animation2, View view2, List list, View view3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x80) != 0) {
            list = null;
        }
        if ((n & 0x100) != 0) {
            view3 = null;
        }
        this(view, iInAppMessage, iInAppMessageViewLifecycleListener, brazeConfigurationProvider, animation, animation2, view2, list, view3);
    }

    @Override
    @NotNull
    public View getInAppMessageView() {
        return this.inAppMessageView;
    }

    @Override
    @NotNull
    public IInAppMessage getInAppMessage() {
        return this.inAppMessage;
    }

    @NotNull
    public IInAppMessageViewLifecycleListener getInAppMessageViewLifecycleListener() {
        return this.inAppMessageViewLifecycleListener;
    }

    @NotNull
    public BrazeConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    @Nullable
    public Animation getOpeningAnimation() {
        return this.openingAnimation;
    }

    @Nullable
    public Animation getClosingAnimation() {
        return this.closingAnimation;
    }

    @Nullable
    public View getClickableInAppMessageView() {
        return this.clickableInAppMessageView;
    }

    public void setClickableInAppMessageView(@Nullable View view) {
        this.clickableInAppMessageView = view;
    }

    @Nullable
    public List<View> getButtonViews() {
        return this.buttonViews;
    }

    public void setButtonViews(@Nullable List<? extends View> list) {
        this.buttonViews = list;
    }

    @Nullable
    public View getCloseButton() {
        return this.closeButton;
    }

    public void setCloseButton(@Nullable View view) {
        this.closeButton = view;
    }

    @NotNull
    public InAppMessageCloser getInAppMessageCloser() {
        return this.inAppMessageCloser;
    }

    public static /* synthetic */ void getInAppMessageCloser$annotations() {
    }

    @Override
    public boolean isAnimatingClose() {
        return this.isAnimatingClose;
    }

    public void setAnimatingClose(boolean bl) {
        this.isAnimatingClose = bl;
    }

    @Nullable
    public Runnable getDismissRunnable() {
        return this.dismissRunnable;
    }

    public void setDismissRunnable(@Nullable Runnable runnable) {
        this.dismissRunnable = runnable;
    }

    @Nullable
    public View getPreviouslyFocusedView() {
        return this.previouslyFocusedView;
    }

    public void setPreviouslyFocusedView(@Nullable View view) {
        this.previouslyFocusedView = view;
    }

    @NotNull
    public HashMap<Integer, Integer> getViewAccessibilityFlagMap() {
        return this.viewAccessibilityFlagMap;
    }

    public void setViewAccessibilityFlagMap(@NotNull HashMap<Integer, Integer> hashMap) {
        Intrinsics.checkNotNullParameter(hashMap, (String)"<set-?>");
        this.viewAccessibilityFlagMap = hashMap;
    }

    @Nullable
    public ViewGroup getContentViewGroupParentLayout() {
        return this.contentViewGroupParentLayout;
    }

    public void setContentViewGroupParentLayout(@Nullable ViewGroup viewGroup) {
        this.contentViewGroupParentLayout = viewGroup;
    }

    @Override
    public void open(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, (Function0)open.1.INSTANCE, (int)6, null);
        ViewGroup parentViewGroup = this.getParentViewGroup(activity);
        int parentViewGroupHeight = parentViewGroup.getHeight();
        if (this.getConfigurationProvider().isInAppMessageAccessibilityExclusiveModeEnabled()) {
            this.setContentViewGroupParentLayout(parentViewGroup);
            this.getViewAccessibilityFlagMap().clear();
            Companion.setAllViewGroupChildrenAsNonAccessibilityImportant(this.getContentViewGroupParentLayout(), (Map<Integer, Integer>)this.getViewAccessibilityFlagMap());
        }
        this.setPreviouslyFocusedView(activity.getCurrentFocus());
        if (parentViewGroupHeight == 0) {
            parentViewGroup.addOnLayoutChangeListener(new View.OnLayoutChangeListener(parentViewGroup, this){
                final /* synthetic */ ViewGroup $parentViewGroup;
                final /* synthetic */ DefaultInAppMessageViewWrapper this$0;
                {
                    this.$parentViewGroup = $parentViewGroup;
                    this.this$0 = $receiver;
                }

                public void onLayoutChange(@NotNull View view, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                    this.$parentViewGroup.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)((Function0)new Function0<String>(bottom, top){
                        final /* synthetic */ int $bottom;
                        final /* synthetic */ int $top;
                        {
                            this.$bottom = $bottom;
                            this.$top = $top;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            return "Detected (bottom - top) of " + (this.$bottom - this.$top) + " in OnLayoutChangeListener";
                        }
                    }), (int)7, null);
                    this.$parentViewGroup.removeView(this.this$0.getInAppMessageView());
                    this.$parentViewGroup.post(() -> open.2.onLayoutChange$lambda$0(this.this$0, this.$parentViewGroup));
                }

                private static final void onLayoutChange$lambda$0(DefaultInAppMessageViewWrapper this$0, ViewGroup $parentViewGroup) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    Intrinsics.checkNotNullParameter((Object)$parentViewGroup, (String)"$parentViewGroup");
                    this$0.addInAppMessageViewToViewGroup($parentViewGroup, this$0.getInAppMessage(), this$0.getInAppMessageView(), this$0.getInAppMessageViewLifecycleListener());
                }
            });
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)((Function0)new Function0<String>(parentViewGroupHeight){
                final /* synthetic */ int $parentViewGroupHeight;
                {
                    this.$parentViewGroupHeight = $parentViewGroupHeight;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Detected root view height of " + this.$parentViewGroupHeight;
                }
            }), (int)7, null);
            this.addInAppMessageViewToViewGroup(parentViewGroup, this.getInAppMessage(), this.getInAppMessageView(), this.getInAppMessageViewLifecycleListener());
        }
        if (BrazeInAppMessageManager.Companion.getInstance().getDoesBackButtonDismissInAppMessageView() && Build.VERSION.SDK_INT >= 33) {
            Activity it = activity;
            boolean bl = false;
            OnBackInvokedCallback dismissInAppMessageCallback2 = new OnBackInvokedCallback(it){
                final /* synthetic */ Activity $it;
                {
                    this.$it = $it;
                }

                public void onBackInvoked() {
                    InAppMessageViewUtils.closeInAppMessageOnKeycodeBack();
                    this.$it.getOnBackInvokedDispatcher().unregisterOnBackInvokedCallback((OnBackInvokedCallback)this);
                }
            };
            it.getOnBackInvokedDispatcher().registerOnBackInvokedCallback(1000000, dismissInAppMessageCallback2);
        }
    }

    @Override
    public void close() {
        if (this.getConfigurationProvider().isInAppMessageAccessibilityExclusiveModeEnabled()) {
            Companion.resetAllViewGroupChildrenToPreviousAccessibilityFlagOrAuto(this.getContentViewGroupParentLayout(), (Map<Integer, Integer>)this.getViewAccessibilityFlagMap());
        }
        this.getInAppMessageView().removeCallbacks(this.getDismissRunnable());
        this.getInAppMessageViewLifecycleListener().beforeClosed(this.getInAppMessageView(), this.getInAppMessage());
        if (this.getInAppMessage().getAnimateOut()) {
            this.setAnimatingClose(true);
            this.setAndStartAnimation(false);
        } else {
            this.closeInAppMessageView();
        }
    }

    @NotNull
    public ViewGroup getParentViewGroup(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        View view = activity.getWindow().getDecorView().findViewById(0x1020002);
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorVie\u2026yId(android.R.id.content)");
        return (ViewGroup)view;
    }

    @NotNull
    public ViewGroup.LayoutParams getLayoutParams(@Nullable IInAppMessage inAppMessage) {
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -2);
        if (inAppMessage instanceof InAppMessageSlideup) {
            layoutParams.gravity = ((InAppMessageSlideup)inAppMessage).getSlideFrom() == SlideFrom.TOP ? 48 : 80;
        }
        return (ViewGroup.LayoutParams)layoutParams;
    }

    public void addInAppMessageViewToViewGroup(@NotNull ViewGroup parentViewGroup, @NotNull IInAppMessage inAppMessage, @NotNull View inAppMessageView, @NotNull IInAppMessageViewLifecycleListener inAppMessageViewLifecycleListener) {
        Intrinsics.checkNotNullParameter((Object)parentViewGroup, (String)"parentViewGroup");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Intrinsics.checkNotNullParameter((Object)inAppMessageView, (String)"inAppMessageView");
        Intrinsics.checkNotNullParameter((Object)inAppMessageViewLifecycleListener, (String)"inAppMessageViewLifecycleListener");
        inAppMessageViewLifecycleListener.beforeOpened(inAppMessageView, inAppMessage);
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)addInAppMessageViewToViewGroup.1.INSTANCE, (int)7, null);
        parentViewGroup.addView(inAppMessageView, this.getLayoutParams(inAppMessage));
        if (inAppMessageView instanceof IInAppMessageView) {
            ViewCompat.requestApplyInsets((View)((View)parentViewGroup));
            ViewCompat.setOnApplyWindowInsetsListener((View)((View)parentViewGroup), (arg_0, arg_1) -> DefaultInAppMessageViewWrapper.addInAppMessageViewToViewGroup$lambda$1(inAppMessageView, this, arg_0, arg_1));
        }
        if (inAppMessage.getAnimateIn()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)addInAppMessageViewToViewGroup.3.INSTANCE, (int)7, null);
            this.setAndStartAnimation(true);
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)addInAppMessageViewToViewGroup.4.INSTANCE, (int)7, null);
            if (inAppMessage.getDismissType() == DismissType.AUTO_DISMISS) {
                this.addDismissRunnable();
            }
            this.finalizeViewBeforeDisplay(inAppMessage, inAppMessageView, inAppMessageViewLifecycleListener);
        }
    }

    public void announceForAccessibilityIfNecessary(@Nullable String fallbackAccessibilityMessage) {
        if (this.getInAppMessageView() instanceof IInAppMessageImmersiveView) {
            String message = this.getInAppMessage().getMessage();
            if (this.getInAppMessage() instanceof IInAppMessageImmersive) {
                IInAppMessage iInAppMessage = this.getInAppMessage();
                Intrinsics.checkNotNull((Object)iInAppMessage, (String)"null cannot be cast to non-null type com.braze.models.inappmessage.IInAppMessageImmersive");
                String header = ((IInAppMessageImmersive)iInAppMessage).getHeader();
                this.getInAppMessageView().announceForAccessibility((CharSequence)(header + " . " + message));
            } else {
                this.getInAppMessageView().announceForAccessibility((CharSequence)message);
            }
        } else if (this.getInAppMessageView() instanceof InAppMessageHtmlBaseView) {
            this.getInAppMessageView().announceForAccessibility((CharSequence)fallbackAccessibilityMessage);
        }
    }

    public static /* synthetic */ void announceForAccessibilityIfNecessary$default(DefaultInAppMessageViewWrapper defaultInAppMessageViewWrapper, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: announceForAccessibilityIfNecessary");
        }
        if ((n & 1) != 0) {
            string2 = "In app message displayed.";
        }
        defaultInAppMessageViewWrapper.announceForAccessibilityIfNecessary(string2);
    }

    @NotNull
    public View.OnClickListener createClickListener() {
        return arg_0 -> DefaultInAppMessageViewWrapper.createClickListener$lambda$2(this, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    public void createButtonClickListeners() {
        block5: {
            IInAppMessage iInAppMessage = this.getInAppMessage();
            IInAppMessageImmersive iInAppMessageImmersive = iInAppMessage instanceof IInAppMessageImmersive ? (IInAppMessageImmersive)iInAppMessage : null;
            if (iInAppMessageImmersive == null) break block5;
            IInAppMessageImmersive immersiveMessage = iInAppMessageImmersive;
            boolean bl = false;
            if (immersiveMessage.getMessageButtons().isEmpty()) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)createButtonClickListeners.1.1.INSTANCE, (int)7, null);
                return;
            }
            List<View> list = this.getButtonViews();
            if (list != null) {
                Iterable $this$forEachIndexed$iv = list;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    View view = (View)item$iv;
                    int index = n;
                    boolean bl2 = false;
                    MessageButton messageButton = (MessageButton)CollectionsKt.getOrNull((List)immersiveMessage.getMessageButtons(), (int)index);
                    if (messageButton != null) {
                        MessageButton button;
                        void view2;
                        boolean bl3 = false;
                        view2.setOnClickListener(arg_0 -> DefaultInAppMessageViewWrapper.createButtonClickListeners$lambda$6$lambda$5$lambda$4$lambda$3(this, button, immersiveMessage, arg_0));
                    }
                }
            }
        }
    }

    @NotNull
    public View.OnClickListener createCloseInAppMessageClickListener() {
        return DefaultInAppMessageViewWrapper::createCloseInAppMessageClickListener$lambda$7;
    }

    public void addDismissRunnable() {
        if (this.getDismissRunnable() == null) {
            this.setDismissRunnable(DefaultInAppMessageViewWrapper::addDismissRunnable$lambda$8);
            this.getInAppMessageView().postDelayed(this.getDismissRunnable(), (long)this.getInAppMessage().getDurationInMilliseconds());
        }
    }

    public void setAndStartAnimation(boolean opening) {
        Animation animation;
        Animation animation2 = animation = opening ? this.getOpeningAnimation() : this.getClosingAnimation();
        if (animation2 != null) {
            animation2.setAnimationListener(this.createAnimationListener(opening));
        }
        this.getInAppMessageView().clearAnimation();
        this.getInAppMessageView().setAnimation(animation);
        Animation animation3 = animation;
        if (animation3 != null) {
            animation3.startNow();
        }
        this.getInAppMessageView().invalidate();
    }

    public void closeInAppMessageView() {
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)closeInAppMessageView.1.INSTANCE, (int)7, null);
        ViewUtils.removeViewFromParent(this.getInAppMessageView());
        View view = this.getInAppMessageView();
        InAppMessageHtmlBaseView inAppMessageHtmlBaseView = view instanceof InAppMessageHtmlBaseView ? (InAppMessageHtmlBaseView)view : null;
        if (inAppMessageHtmlBaseView != null) {
            inAppMessageHtmlBaseView.finishWebViewDisplay();
        }
        if (this.getPreviouslyFocusedView() != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ DefaultInAppMessageViewWrapper this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Returning focus to view after closing message. View: " + this.this$0.getPreviouslyFocusedView();
                }
            }), (int)7, null);
            try {
                View view2 = this.getPreviouslyFocusedView();
                if (view2 != null) {
                    view2.requestFocus();
                }
            }
            catch (Exception e) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.E, (Throwable)e, (boolean)false, (Function0)closeInAppMessageView.3.INSTANCE, (int)4, null);
            }
        }
        this.getInAppMessageViewLifecycleListener().afterClosed(this.getInAppMessage());
    }

    public void finalizeViewBeforeDisplay(@NotNull IInAppMessage inAppMessage, @NotNull View inAppMessageView, @NotNull IInAppMessageViewLifecycleListener inAppMessageViewLifecycleListener) {
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Intrinsics.checkNotNullParameter((Object)inAppMessageView, (String)"inAppMessageView");
        Intrinsics.checkNotNullParameter((Object)inAppMessageViewLifecycleListener, (String)"inAppMessageViewLifecycleListener");
        if (ViewUtils.isDeviceNotInTouchMode(inAppMessageView)) {
            switch (WhenMappings.$EnumSwitchMapping$0[inAppMessage.getMessageType().ordinal()]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                default: {
                    ViewUtils.setFocusableInTouchModeAndRequestFocus(inAppMessageView);
                    break;
                }
            }
        } else {
            ViewUtils.setFocusableInTouchModeAndRequestFocus(inAppMessageView);
        }
        DefaultInAppMessageViewWrapper.announceForAccessibilityIfNecessary$default(this, null, 1, null);
        inAppMessageViewLifecycleListener.afterOpened(inAppMessageView, inAppMessage);
    }

    @NotNull
    public SwipeDismissTouchListener.DismissCallbacks createDismissCallbacks() {
        return new SwipeDismissTouchListener.DismissCallbacks(this){
            final /* synthetic */ DefaultInAppMessageViewWrapper this$0;
            {
                this.this$0 = $receiver;
            }

            public boolean canDismiss(@Nullable Object token) {
                return true;
            }

            public void onDismiss(@NotNull View view, @Nullable Object token) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                this.this$0.getInAppMessage().setAnimateOut(false);
                BrazeInAppMessageManager.Companion.getInstance().hideCurrentlyDisplayingInAppMessage(true);
            }
        };
    }

    @NotNull
    public TouchAwareSwipeDismissTouchListener.ITouchListener createTouchAwareListener() {
        return new TouchAwareSwipeDismissTouchListener.ITouchListener(){

            public void onTouchStartedOrContinued() {
            }

            public void onTouchEnded() {
            }
        };
    }

    @NotNull
    public Animation.AnimationListener createAnimationListener(boolean opening) {
        return opening ? (Animation.AnimationListener)new Animation.AnimationListener(this){
            final /* synthetic */ DefaultInAppMessageViewWrapper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationStart(@Nullable Animation animation) {
            }

            public void onAnimationEnd(@Nullable Animation animation) {
                if (this.this$0.getInAppMessage().getDismissType() == DismissType.AUTO_DISMISS) {
                    this.this$0.addDismissRunnable();
                }
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)createAnimationListener.onAnimationEnd.1.INSTANCE, (int)7, null);
                this.this$0.finalizeViewBeforeDisplay(this.this$0.getInAppMessage(), this.this$0.getInAppMessageView(), this.this$0.getInAppMessageViewLifecycleListener());
            }

            public void onAnimationRepeat(@Nullable Animation animation) {
            }
        } : (Animation.AnimationListener)new Animation.AnimationListener(this){
            final /* synthetic */ DefaultInAppMessageViewWrapper this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAnimationStart(@Nullable Animation animation) {
            }

            public void onAnimationEnd(@Nullable Animation animation) {
                this.this$0.getInAppMessageView().clearAnimation();
                this.this$0.getInAppMessageView().setVisibility(8);
                this.this$0.closeInAppMessageView();
            }

            public void onAnimationRepeat(@Nullable Animation animation) {
            }
        };
    }

    @JvmOverloads
    public DefaultInAppMessageViewWrapper(@NotNull View inAppMessageView, @NotNull IInAppMessage inAppMessage, @NotNull IInAppMessageViewLifecycleListener inAppMessageViewLifecycleListener, @NotNull BrazeConfigurationProvider configurationProvider, @Nullable Animation openingAnimation, @Nullable Animation closingAnimation, @Nullable View clickableInAppMessageView, @Nullable List<? extends View> buttonViews) {
        Intrinsics.checkNotNullParameter((Object)inAppMessageView, (String)"inAppMessageView");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Intrinsics.checkNotNullParameter((Object)inAppMessageViewLifecycleListener, (String)"inAppMessageViewLifecycleListener");
        Intrinsics.checkNotNullParameter((Object)configurationProvider, (String)"configurationProvider");
        this(inAppMessageView, inAppMessage, inAppMessageViewLifecycleListener, configurationProvider, openingAnimation, closingAnimation, clickableInAppMessageView, buttonViews, null, 256, null);
    }

    @JvmOverloads
    public DefaultInAppMessageViewWrapper(@NotNull View inAppMessageView, @NotNull IInAppMessage inAppMessage, @NotNull IInAppMessageViewLifecycleListener inAppMessageViewLifecycleListener, @NotNull BrazeConfigurationProvider configurationProvider, @Nullable Animation openingAnimation, @Nullable Animation closingAnimation, @Nullable View clickableInAppMessageView) {
        Intrinsics.checkNotNullParameter((Object)inAppMessageView, (String)"inAppMessageView");
        Intrinsics.checkNotNullParameter((Object)inAppMessage, (String)"inAppMessage");
        Intrinsics.checkNotNullParameter((Object)inAppMessageViewLifecycleListener, (String)"inAppMessageViewLifecycleListener");
        Intrinsics.checkNotNullParameter((Object)configurationProvider, (String)"configurationProvider");
        this(inAppMessageView, inAppMessage, inAppMessageViewLifecycleListener, configurationProvider, openingAnimation, closingAnimation, clickableInAppMessageView, null, null, 384, null);
    }

    private static final WindowInsetsCompat addInAppMessageViewToViewGroup$lambda$1(View $inAppMessageView, DefaultInAppMessageViewWrapper this$0, View view, WindowInsetsCompat insets) {
        Intrinsics.checkNotNullParameter((Object)$inAppMessageView, (String)"$inAppMessageView");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (insets == null) {
            return new WindowInsetsCompat(insets);
        }
        IInAppMessageView castInAppMessageView = (IInAppMessageView)$inAppMessageView;
        if (!castInAppMessageView.getHasAppliedWindowInsets()) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, (Function0)addInAppMessageViewToViewGroup.2.1.INSTANCE, (int)6, null);
            castInAppMessageView.applyWindowInsets(insets);
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this$0, null, null, (boolean)false, (Function0)addInAppMessageViewToViewGroup.2.2.INSTANCE, (int)7, null);
        }
        return insets;
    }

    private static final void createClickListener$lambda$2(DefaultInAppMessageViewWrapper this$0, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        IInAppMessage iInAppMessage = this$0.getInAppMessage();
        Object object = iInAppMessage instanceof IInAppMessageImmersive ? (IInAppMessageImmersive)iInAppMessage : null;
        boolean bl = object != null && (object = object.getMessageButtons()) != null ? object.isEmpty() : false;
        if (bl || !(this$0.getInAppMessage() instanceof IInAppMessageImmersive)) {
            this$0.getInAppMessageViewLifecycleListener().onClicked(this$0.getInAppMessageCloser(), this$0.getInAppMessageView(), this$0.getInAppMessage());
        }
    }

    private static final void createButtonClickListeners$lambda$6$lambda$5$lambda$4$lambda$3(DefaultInAppMessageViewWrapper this$0, MessageButton $button, IInAppMessageImmersive $immersiveMessage, View it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$button, (String)"$button");
        Intrinsics.checkNotNullParameter((Object)$immersiveMessage, (String)"$immersiveMessage");
        this$0.getInAppMessageViewLifecycleListener().onButtonClicked(this$0.getInAppMessageCloser(), $button, $immersiveMessage);
    }

    private static final void createCloseInAppMessageClickListener$lambda$7(View it) {
        BrazeInAppMessageManager.Companion.getInstance().hideCurrentlyDisplayingInAppMessage(true);
    }

    private static final void addDismissRunnable$lambda$8() {
        BrazeInAppMessageManager.Companion.getInstance().hideCurrentlyDisplayingInAppMessage(true);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bJ$\u0010\n\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u000b\u00a8\u0006\f"}, d2={"Lcom/braze/ui/inappmessage/DefaultInAppMessageViewWrapper$Companion;", "", "()V", "resetAllViewGroupChildrenToPreviousAccessibilityFlagOrAuto", "", "viewGroup", "Landroid/view/ViewGroup;", "viewAccessibilityFlagMap", "", "", "setAllViewGroupChildrenAsNonAccessibilityImportant", "", "android-sdk-ui_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void setAllViewGroupChildrenAsNonAccessibilityImportant(@Nullable ViewGroup viewGroup, @NotNull Map<Integer, Integer> viewAccessibilityFlagMap) {
            Intrinsics.checkNotNullParameter(viewAccessibilityFlagMap, (String)"viewAccessibilityFlagMap");
            if (viewGroup == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)setAllViewGroupChildrenAsNonAccessibilityImportant.1.INSTANCE, (int)6, null);
                return;
            }
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                View child = viewGroup.getChildAt(i);
                if (child == null) continue;
                viewAccessibilityFlagMap.put(child.getId(), child.getImportantForAccessibility());
                ViewCompat.setImportantForAccessibility((View)child, (int)4);
            }
        }

        public final void resetAllViewGroupChildrenToPreviousAccessibilityFlagOrAuto(@Nullable ViewGroup viewGroup, @NotNull Map<Integer, Integer> viewAccessibilityFlagMap) {
            Intrinsics.checkNotNullParameter(viewAccessibilityFlagMap, (String)"viewAccessibilityFlagMap");
            if (viewGroup == null) {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.W, null, (boolean)false, (Function0)resetAllViewGroupChildrenToPreviousAccessibilityFlagOrAuto.1.INSTANCE, (int)6, null);
                return;
            }
            int n = viewGroup.getChildCount();
            for (int i = 0; i < n; ++i) {
                View child = viewGroup.getChildAt(i);
                if (child == null) continue;
                int id2 = child.getId();
                if (viewAccessibilityFlagMap.containsKey(id2)) {
                    Integer n2 = viewAccessibilityFlagMap.get(id2);
                    if (n2 != null) {
                        int it = ((Number)n2).intValue();
                        boolean bl = false;
                        ViewCompat.setImportantForAccessibility((View)child, (int)it);
                    }
                    continue;
                }
                ViewCompat.setImportantForAccessibility((View)child, (int)0);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MessageType.values().length];
            try {
                nArray[MessageType.MODAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.FULL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.HTML_FULL.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MessageType.HTML.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

