/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui.contentcards;

import android.content.Context;
import android.os.Bundle;
import com.braze.models.cards.Card;
import com.braze.support.BrazeLogger;
import com.braze.ui.BrazeDeeplinkHandler;
import com.braze.ui.actions.UriAction;
import com.braze.ui.actions.brazeactions.BrazeActionUtils;
import com.braze.ui.contentcards.BrazeContentCardUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0005J,\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u00052\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a8\u0006\u0011"}, d2={"Lcom/braze/ui/contentcards/BrazeContentCardUtils;", "", "()V", "defaultCardHandling", "", "Lcom/braze/models/cards/Card;", "cards", "getUriActionForCard", "Lcom/braze/ui/actions/UriAction;", "card", "handleCardClick", "", "context", "Landroid/content/Context;", "clickHandler", "Lkotlin/Function1;", "", "android-sdk-ui_release"})
@SourceDebugExtension(value={"SMAP\nBrazeContentCardUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrazeContentCardUtils.kt\ncom/braze/ui/contentcards/BrazeContentCardUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n766#2:92\n857#2,2:93\n*S KotlinDebug\n*F\n+ 1 BrazeContentCardUtils.kt\ncom/braze/ui/contentcards/BrazeContentCardUtils\n*L\n41#1:92\n41#1:93,2\n*E\n"})
public final class BrazeContentCardUtils {
    @NotNull
    public static final BrazeContentCardUtils INSTANCE = new BrazeContentCardUtils();

    private BrazeContentCardUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Card> defaultCardHandling(@NotNull List<? extends Card> cards) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(cards, (String)"cards");
        Comparator cardComparator = BrazeContentCardUtils::defaultCardHandling$lambda$0;
        Iterable $this$filter$iv = cards;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Card card = (Card)element$iv$iv;
            boolean bl = false;
            if (!(!BrazeActionUtils.containsInvalidBrazeAction(card))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)cardComparator);
    }

    @Nullable
    public final UriAction getUriActionForCard(@NotNull Card card) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        String url = card.getUrl();
        if (url == null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, (Function0)getUriActionForCard.1.INSTANCE, (int)6, null);
            return null;
        }
        Bundle extras = new Bundle();
        for (String key : card.getExtras().keySet()) {
            extras.putString(key, (String)card.getExtras().get(key));
        }
        return BrazeDeeplinkHandler.Companion.getInstance().createUriActionFromUrlString(url, extras, card.getOpenUriInWebView(), card.getChannel());
    }

    public final void handleCardClick(@NotNull Context context, @NotNull Card card, @Nullable Function1<? super Card, Boolean> clickHandler) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, (Function0)((Function0)new Function0<String>(card){
            final /* synthetic */ Card $card;
            {
                this.$card = $card;
                super(0);
            }

            @NotNull
            public final String invoke() {
                return "Handling card click for card: " + this.$card;
            }
        }), (int)6, null);
        card.setIndicatorHighlighted(true);
        boolean isCustomHandled = false;
        if (clickHandler != null) {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)handleCardClick.2.INSTANCE, (int)7, null);
            isCustomHandled = (Boolean)clickHandler.invoke((Object)card);
        }
        if (!isCustomHandled) {
            UriAction cardAction = this.getUriActionForCard(card);
            if (cardAction != null) {
                card.logClick();
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, (Function0)((Function0)new Function0<String>(card){
                    final /* synthetic */ Card $card;
                    {
                        this.$card = $card;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Card action is non-null. Attempting to perform action on card: " + this.$card.getId();
                    }
                }), (int)6, null);
                BrazeDeeplinkHandler.Companion.getInstance().gotoUri(context, cardAction);
            } else {
                BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, (BrazeLogger.Priority)BrazeLogger.Priority.V, null, (boolean)false, (Function0)((Function0)new Function0<String>(card){
                    final /* synthetic */ Card $card;
                    {
                        this.$card = $card;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Card action is null. Not performing any click action on card: " + this.$card.getId();
                    }
                }), (int)6, null);
            }
        } else {
            BrazeLogger.brazelog$default((BrazeLogger)BrazeLogger.INSTANCE, (Object)this, null, null, (boolean)false, (Function0)((Function0)new Function0<String>(card){
                final /* synthetic */ Card $card;
                {
                    this.$card = $card;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "Card click was handled by custom listener on card: " + this.$card.getId();
                }
            }), (int)7, null);
            card.logClick();
        }
    }

    private static final int defaultCardHandling$lambda$0(Card cardA, Card cardB) {
        Intrinsics.checkNotNullParameter((Object)cardA, (String)"cardA");
        Intrinsics.checkNotNullParameter((Object)cardB, (String)"cardB");
        return cardA.isPinned() && !cardB.isPinned() ? -1 : (!cardA.isPinned() && cardB.isPinned() ? 1 : (cardA.getCreated() > cardB.getCreated() ? -1 : (cardA.getCreated() < cardB.getCreated() ? 1 : (cardA.getId().compareTo(cardB.getId()) > 0 ? -1 : (cardA.getId().compareTo(cardB.getId()) < 0 ? 1 : 0)))));
    }
}

