/*
 * Decompiled with CFR 0.152.
 */
package com.braze.ui;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.VisibleForTesting;
import androidx.core.view.GestureDetectorCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.ListFragment;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.braze.Braze;
import com.braze.enums.CardCategory;
import com.braze.events.FeedUpdatedEvent;
import com.braze.events.IEventSubscriber;
import com.braze.models.cards.Card;
import com.braze.support.BrazeLogger;
import com.braze.support.DateTimeUtils;
import com.braze.ui.R;
import com.braze.ui.adapters.BrazeListAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class BrazeFeedFragment
extends ListFragment
implements SwipeRefreshLayout.OnRefreshListener {
    private static final String TAG = BrazeLogger.getBrazeLogTag(BrazeFeedFragment.class);
    private static final int NETWORK_PROBLEM_WARNING_MS = 5000;
    private static final int MAX_FEED_TTL_SECONDS = 60;
    private static final long AUTO_HIDE_REFRESH_INDICATOR_DELAY_MS = 2500L;
    @VisibleForTesting
    static final String SAVED_INSTANCE_STATE_KEY_PREVIOUS_VISIBLE_HEAD_CARD_INDEX = "PREVIOUS_VISIBLE_HEAD_CARD_INDEX";
    @VisibleForTesting
    static final String SAVED_INSTANCE_STATE_KEY_CURRENT_CARD_INDEX_AT_BOTTOM_OF_SCREEN = "CURRENT_CARD_INDEX_AT_BOTTOM_OF_SCREEN";
    @VisibleForTesting
    static final String SAVED_INSTANCE_STATE_KEY_SKIP_CARD_IMPRESSIONS_RESET = "SKIP_CARD_IMPRESSIONS_RESET";
    @VisibleForTesting
    static final String SAVED_INSTANCE_STATE_KEY_CARD_CATEGORY = "CARD_CATEGORY";
    private final Handler mMainThreadLooper = new Handler(Looper.getMainLooper());
    private final Runnable mShowNetworkError = new Runnable(){

        @Override
        public void run() {
            if (BrazeFeedFragment.this.mLoadingSpinner != null) {
                BrazeFeedFragment.this.mLoadingSpinner.setVisibility(8);
            }
            if (BrazeFeedFragment.this.mNetworkErrorLayout != null) {
                BrazeFeedFragment.this.mNetworkErrorLayout.setVisibility(0);
            }
        }
    };
    private IEventSubscriber<FeedUpdatedEvent> mFeedUpdatedSubscriber;
    private BrazeListAdapter mAdapter;
    private LinearLayout mNetworkErrorLayout;
    private LinearLayout mEmptyFeedLayout;
    private ProgressBar mLoadingSpinner;
    private RelativeLayout mFeedRootLayout;
    private EnumSet<CardCategory> mCategories;
    private SwipeRefreshLayout mFeedSwipeLayout;
    private GestureDetectorCompat mGestureDetector;
    private boolean mSortEnabled = false;
    @VisibleForTesting
    boolean mSkipCardImpressionsReset = false;
    @VisibleForTesting
    int mPreviousVisibleHeadCardIndex = 0;
    @VisibleForTesting
    int mCurrentCardIndexAtBottomOfScreen = 0;
    private View mTransparentFullBoundsContainerView;

    public void onAttach(Context context) {
        super.onAttach(context);
        if (this.mAdapter == null) {
            this.mAdapter = new BrazeListAdapter(context, R.id.tag, new ArrayList<Card>());
            this.mCategories = CardCategory.getAllCategories();
        }
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)new FeedGestureListener());
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup container, Bundle savedInstanceState) {
        View view = layoutInflater.inflate(R.layout.com_braze_feed, container, false);
        this.mNetworkErrorLayout = (LinearLayout)view.findViewById(R.id.com_braze_feed_network_error);
        this.mLoadingSpinner = (ProgressBar)view.findViewById(R.id.com_braze_feed_loading_spinner);
        this.mEmptyFeedLayout = (LinearLayout)view.findViewById(R.id.com_braze_feed_empty_feed);
        this.mFeedRootLayout = (RelativeLayout)view.findViewById(R.id.com_braze_feed_root);
        this.mFeedSwipeLayout = (SwipeRefreshLayout)view.findViewById(R.id.braze_feed_swipe_container);
        this.mFeedSwipeLayout.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.mFeedSwipeLayout.setEnabled(false);
        this.mFeedSwipeLayout.setColorSchemeResources(new int[]{R.color.com_braze_newsfeed_swipe_refresh_color_1, R.color.com_braze_newsfeed_swipe_refresh_color_2, R.color.com_braze_newsfeed_swipe_refresh_color_3, R.color.com_braze_newsfeed_swipe_refresh_color_4});
        this.mTransparentFullBoundsContainerView = view.findViewById(R.id.com_braze_feed_transparent_full_bounds_container_view);
        return view;
    }

    @SuppressLint(value={"InflateParams"})
    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.loadFragmentStateFromSavedInstanceState(savedInstanceState);
        if (this.mSkipCardImpressionsReset) {
            this.mSkipCardImpressionsReset = false;
        } else {
            this.mAdapter.resetCardImpressionTracker();
            BrazeLogger.d((String)TAG, (String)"Resetting card impressions.");
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.getActivity());
        ListView listView = this.getListView();
        listView.addHeaderView(inflater.inflate(R.layout.com_braze_feed_header, null));
        listView.addFooterView(inflater.inflate(R.layout.com_braze_feed_footer, null));
        this.mFeedRootLayout.setOnTouchListener((currentView, motionEvent) -> this.mGestureDetector.onTouchEvent(motionEvent));
        listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
            }

            public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                BrazeFeedFragment.this.mFeedSwipeLayout.setEnabled(firstVisibleItem == 0);
                if (visibleItemCount == 0) {
                    return;
                }
                int currentVisibleHeadCardIndex = firstVisibleItem - 1;
                if (currentVisibleHeadCardIndex > BrazeFeedFragment.this.mPreviousVisibleHeadCardIndex) {
                    BrazeFeedFragment.this.mAdapter.batchSetCardsToRead(BrazeFeedFragment.this.mPreviousVisibleHeadCardIndex, currentVisibleHeadCardIndex);
                }
                BrazeFeedFragment.this.mPreviousVisibleHeadCardIndex = currentVisibleHeadCardIndex;
                BrazeFeedFragment.this.mCurrentCardIndexAtBottomOfScreen = firstVisibleItem + visibleItemCount;
            }
        });
        this.mTransparentFullBoundsContainerView.setOnTouchListener((currentView, motionEvent) -> currentView.getVisibility() == 0);
        Braze.getInstance((Context)this.getContext()).removeSingleSubscription(this.mFeedUpdatedSubscriber, FeedUpdatedEvent.class);
        this.mFeedUpdatedSubscriber = event -> {
            FragmentActivity activity = this.getActivity();
            if (activity == null) {
                return;
            }
            activity.runOnUiThread(() -> {
                BrazeLogger.v((String)TAG, (String)("Updating feed views in response to FeedUpdatedEvent: " + event));
                this.mMainThreadLooper.removeCallbacks(this.mShowNetworkError);
                this.mNetworkErrorLayout.setVisibility(8);
                if (event.getCardCount(this.mCategories) == 0) {
                    listView.setVisibility(8);
                    this.mAdapter.clear();
                } else {
                    this.mEmptyFeedLayout.setVisibility(8);
                    this.mLoadingSpinner.setVisibility(8);
                    this.mTransparentFullBoundsContainerView.setVisibility(8);
                }
                if (event.isFromOfflineStorage() && (event.lastUpdatedInSecondsFromEpoch() + 60L) * 1000L < DateTimeUtils.nowInMilliseconds()) {
                    BrazeLogger.i((String)TAG, (String)"Feed received was older than the max time to live of 60 seconds, displaying it for now, but requesting an updated view from the server.");
                    Braze.getInstance((Context)this.getContext()).requestFeedRefresh();
                    if (event.getCardCount(this.mCategories) == 0) {
                        BrazeLogger.d((String)TAG, (String)"Old feed was empty, putting up a network spinner and registering the network error message with a delay of 5000ms.");
                        this.mEmptyFeedLayout.setVisibility(8);
                        this.mLoadingSpinner.setVisibility(0);
                        this.mTransparentFullBoundsContainerView.setVisibility(0);
                        this.mMainThreadLooper.postDelayed(this.mShowNetworkError, 5000L);
                        return;
                    }
                }
                if (event.getCardCount(this.mCategories) == 0) {
                    this.mLoadingSpinner.setVisibility(8);
                    this.mEmptyFeedLayout.setVisibility(0);
                    this.mTransparentFullBoundsContainerView.setVisibility(0);
                } else {
                    if (this.mSortEnabled && event.getCardCount(this.mCategories) != event.getUnreadCardCount(this.mCategories)) {
                        this.mAdapter.replaceFeed(this.sortFeedCards(event.getFeedCards(this.mCategories)));
                    } else {
                        this.mAdapter.replaceFeed(event.getFeedCards(this.mCategories));
                    }
                    listView.setVisibility(0);
                }
                this.mFeedSwipeLayout.setRefreshing(false);
            });
        };
        Braze.getInstance((Context)this.getContext()).subscribeToFeedUpdates(this.mFeedUpdatedSubscriber);
        listView.setAdapter((ListAdapter)this.mAdapter);
        Braze.getInstance((Context)this.getContext()).requestFeedRefreshFromCache();
    }

    public List<Card> sortFeedCards(List<Card> cards) {
        Collections.sort(cards, (cardOne, cardTwo) -> cardOne.isIndicatorHighlighted() == cardTwo.isIndicatorHighlighted() ? 0 : (cardOne.isIndicatorHighlighted() ? 1 : -1));
        return cards;
    }

    public void onResume() {
        super.onResume();
        Braze.getInstance((Context)this.getContext()).logFeedDisplayed();
    }

    public void onDestroyView() {
        super.onDestroyView();
        Braze.getInstance((Context)this.getContext()).removeSingleSubscription(this.mFeedUpdatedSubscriber, FeedUpdatedEvent.class);
        this.setOnScreenCardsToRead();
    }

    public void onPause() {
        super.onPause();
        this.setOnScreenCardsToRead();
    }

    private void setOnScreenCardsToRead() {
        this.mAdapter.batchSetCardsToRead(this.mPreviousVisibleHeadCardIndex, this.mCurrentCardIndexAtBottomOfScreen);
    }

    public void onDetach() {
        super.onDetach();
        this.setListAdapter(null);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putInt(SAVED_INSTANCE_STATE_KEY_PREVIOUS_VISIBLE_HEAD_CARD_INDEX, this.mPreviousVisibleHeadCardIndex);
        outState.putInt(SAVED_INSTANCE_STATE_KEY_CURRENT_CARD_INDEX_AT_BOTTOM_OF_SCREEN, this.mCurrentCardIndexAtBottomOfScreen);
        outState.putBoolean(SAVED_INSTANCE_STATE_KEY_SKIP_CARD_IMPRESSIONS_RESET, this.mSkipCardImpressionsReset);
        if (this.mCategories == null) {
            this.mCategories = CardCategory.getAllCategories();
        }
        ArrayList<String> cardCategoryArrayList = new ArrayList<String>(this.mCategories.size());
        for (CardCategory cardCategory : this.mCategories) {
            cardCategoryArrayList.add(cardCategory.name());
        }
        outState.putStringArrayList(SAVED_INSTANCE_STATE_KEY_CARD_CATEGORY, cardCategoryArrayList);
        super.onSaveInstanceState(outState);
        if (this.isVisible()) {
            this.mSkipCardImpressionsReset = true;
        }
    }

    @VisibleForTesting
    void loadFragmentStateFromSavedInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState == null) {
            return;
        }
        if (this.mCategories == null) {
            this.mCategories = CardCategory.getAllCategories();
        }
        this.mPreviousVisibleHeadCardIndex = savedInstanceState.getInt(SAVED_INSTANCE_STATE_KEY_PREVIOUS_VISIBLE_HEAD_CARD_INDEX, 0);
        this.mCurrentCardIndexAtBottomOfScreen = savedInstanceState.getInt(SAVED_INSTANCE_STATE_KEY_CURRENT_CARD_INDEX_AT_BOTTOM_OF_SCREEN, 0);
        this.mSkipCardImpressionsReset = savedInstanceState.getBoolean(SAVED_INSTANCE_STATE_KEY_SKIP_CARD_IMPRESSIONS_RESET, false);
        ArrayList cardCategoryArrayList = savedInstanceState.getStringArrayList(SAVED_INSTANCE_STATE_KEY_CARD_CATEGORY);
        if (cardCategoryArrayList != null) {
            this.mCategories.clear();
            for (String cardCategoryString : cardCategoryArrayList) {
                this.mCategories.add(CardCategory.valueOf((String)cardCategoryString));
            }
        }
    }

    public EnumSet<CardCategory> getCategories() {
        return this.mCategories;
    }

    public boolean getSortEnabled() {
        return this.mSortEnabled;
    }

    public void setSortEnabled(boolean sortEnabled) {
        this.mSortEnabled = sortEnabled;
    }

    public void setCategory(CardCategory category) {
        this.setCategories(EnumSet.of(category));
    }

    public void setCategories(EnumSet<CardCategory> categories) {
        if (categories == null) {
            BrazeLogger.i((String)TAG, (String)"The categories passed into setCategories are null, BrazeFeedFragment is going to display all the cards in cache.");
            this.mCategories = CardCategory.getAllCategories();
        } else {
            if (categories.isEmpty()) {
                BrazeLogger.w((String)TAG, (String)"The categories set had no elements and have been ignored. Please pass a valid EnumSet of CardCategory.");
                return;
            }
            if (categories.equals(this.mCategories)) {
                return;
            }
            this.mCategories = categories;
        }
        if (Braze.getInstance((Context)this.getContext()) != null) {
            Braze.getInstance((Context)this.getContext()).requestFeedRefreshFromCache();
        }
    }

    public void onRefresh() {
        Braze.getInstance((Context)this.getContext()).requestFeedRefresh();
        this.mMainThreadLooper.postDelayed(() -> this.mFeedSwipeLayout.setRefreshing(false), 2500L);
    }

    public class FeedGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onDown(MotionEvent motionEvent) {
            return true;
        }

        public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float dx, float dy) {
            BrazeFeedFragment.this.getListView().smoothScrollBy((int)dy, 0);
            return true;
        }

        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float velocityX, float velocityY) {
            long deltaTimeMillis = (motionEvent2.getEventTime() - motionEvent.getEventTime()) * 2L;
            int scrollDistance = (int)(velocityY * (float)deltaTimeMillis / 1000.0f);
            BrazeFeedFragment.this.getListView().smoothScrollBy(-scrollDistance, (int)(deltaTimeMillis * 2L));
            return true;
        }
    }
}

