/*
 * Decompiled with CFR 0.152.
 */
package com.example.bxlargeimageviewer;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DimenRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.AlertDialog;
import android.view.View;
import android.view.ViewGroup;
import com.example.bxlargeimageviewer.Adapters.ImageViewAdapter;
import com.example.bxlargeimageviewer.R;
import java.util.List;

public class BxImageViewer {
    @NonNull
    private Builder builder;
    private int totalImages = 0;
    @Nullable
    private ImageViewAdapter imageViewAdapter;
    @Nullable
    private View imageViewer;
    @Nullable
    private ViewPager viewPager;
    @Nullable
    private ViewGroup headerContainer;
    @Nullable
    private AlertDialog alertDialog;
    private ViewPager.OnPageChangeListener onPageChangeListener = new ViewPager.OnPageChangeListener(){

        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        public void onPageSelected(int position) {
            if (BxImageViewer.this.builder.imageChangeListener != null) {
                BxImageViewer.this.builder.imageChangeListener.onImageChanged(position);
            }
        }

        public void onPageScrollStateChanged(int state) {
        }
    };

    private BxImageViewer(@NonNull Builder builder) {
        this.builder = builder;
        this.initView();
        this.initAdapter();
        this.setDataSet();
        this.setOverlayView();
        this.setBackgroundColor();
        this.setImageMarginPx();
        this.setProgressBarColor();
    }

    private void initView() {
        this.imageViewer = View.inflate((Context)this.builder.mContext, (int)R.layout.image_view_layout, null);
        this.viewPager = (ViewPager)this.imageViewer.findViewById(R.id.my_pager);
        this.headerContainer = (ViewGroup)this.imageViewer.findViewById(R.id.header_container);
    }

    private void initAdapter() {
        this.imageViewAdapter = new ImageViewAdapter(this.builder.mContext);
    }

    private void setViewPagerListener() {
        if (this.viewPager != null) {
            this.viewPager.setOnPageChangeListener(this.onPageChangeListener);
        }
    }

    private void setViewPagerAdapter() {
        if (this.viewPager != null && this.imageViewAdapter != null) {
            this.viewPager.setAdapter((PagerAdapter)this.imageViewAdapter);
        }
    }

    private void setupAlertDialog() {
        this.alertDialog = new AlertDialog.Builder(this.builder.mContext, 0x1030011).setView(this.imageViewer).create();
    }

    private void setDataSet() {
        if (this.builder.imageURIs != null) {
            this.totalImages = this.builder.imageURIs.size();
        }
        if (this.viewPager != null && this.imageViewAdapter != null) {
            this.imageViewAdapter.addDataSet(this.builder.imageURIs);
        }
    }

    private void setOverlayView() {
        if (this.headerContainer == null || this.builder.headerView == null) {
            return;
        }
        this.headerContainer.removeAllViews();
        this.headerContainer.addView(this.builder.headerView);
    }

    private void setBackgroundColor() {
        try {
            if (this.imageViewer != null) {
                this.imageViewer.setBackgroundColor(this.builder.backgroundColor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setImageMarginPx() {
        try {
            if (this.viewPager != null) {
                this.viewPager.setPageMargin(this.builder.imageMarginPixels);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setProgressBarColor() {
        if (this.imageViewAdapter != null) {
            this.imageViewAdapter.setProgressBarColor(this.builder.progressbarColor);
        }
    }

    public void show() {
        this.setupAlertDialog();
        if (this.alertDialog == null || this.alertDialog.isShowing()) {
            return;
        }
        this.setViewPagerAdapter();
        this.setViewPagerListener();
        if (this.builder.startingPos >= this.totalImages) {
            this.builder.startingPos = this.totalImages - 1;
        }
        if (this.viewPager != null && this.builder.startingPos > 0) {
            this.viewPager.setCurrentItem(this.builder.startingPos);
        }
        if (this.builder.imageChangeListener != null) {
            this.builder.imageChangeListener.onImageChanged(this.builder.startingPos);
        }
        if (this.totalImages > 0) {
            this.alertDialog.show();
        }
    }

    public void dismiss() {
        if (this.alertDialog != null && this.alertDialog.isShowing()) {
            this.alertDialog.dismiss();
        }
    }

    public static interface OnImageChangeListener {
        public void onImageChanged(int var1);
    }

    public static class Builder {
        @NonNull
        private final Context mContext;
        @Nullable
        private OnImageChangeListener imageChangeListener;
        @Nullable
        private List<String> imageURIs;
        private int startingPos = 0;
        @ColorInt
        private int backgroundColor;
        @ColorInt
        private int progressbarColor;
        private int imageMarginPixels;
        @Nullable
        private View headerView;

        public Builder(@NonNull Context mContext) {
            this.mContext = mContext;
            this.backgroundColor = mContext.getResources().getColor(R.color.bxColorBlack);
            this.progressbarColor = mContext.getResources().getColor(R.color.bxColorWhite);
            this.imageMarginPixels = 0;
        }

        @NonNull
        public Builder setImageChangeListener(@Nullable OnImageChangeListener imageChangeListener) {
            this.imageChangeListener = imageChangeListener;
            return this;
        }

        @NonNull
        public Builder setDataSet(@Nullable List<String> imageURIs) {
            this.imageURIs = imageURIs;
            return this;
        }

        @NonNull
        public Builder setStartPosition(int pos) {
            this.startingPos = pos < 0 ? 0 : pos;
            return this;
        }

        @NonNull
        public Builder setBackgroundColorRes(@ColorRes int color2) {
            this.backgroundColor = this.mContext.getResources().getColor(color2);
            return this;
        }

        @NonNull
        public Builder setBackgroundColor(@ColorInt int color2) {
            this.backgroundColor = color2;
            return this;
        }

        @NonNull
        public Builder setProgressbarColorRes(@ColorRes int color2) {
            this.progressbarColor = this.mContext.getResources().getColor(color2);
            return this;
        }

        @NonNull
        public Builder setProgressbarColor(@ColorInt int color2) {
            this.progressbarColor = color2;
            return this;
        }

        @NonNull
        public Builder setImageMarginRes(@DimenRes int dimen) {
            try {
                this.imageMarginPixels = Math.round(this.mContext.getResources().getDimension(dimen));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this;
        }

        @NonNull
        public Builder setImageMarginPx(int dimen) {
            this.imageMarginPixels = dimen;
            return this;
        }

        @NonNull
        public Builder setHeaderView(@Nullable View headerView) {
            this.headerView = headerView;
            return this;
        }

        @NonNull
        public BxImageViewer show() {
            BxImageViewer viewer = this.create();
            viewer.show();
            return viewer;
        }

        @NonNull
        public BxImageViewer create() {
            return new BxImageViewer(this);
        }
    }
}

