/*
 * Decompiled with CFR 0.152.
 */
package com.example.bxlargeimageviewer.Adapters;

import android.os.Bundle;
import android.os.Parcelable;
import android.support.v4.view.PagerAdapter;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import com.example.bxlargeimageviewer.ViewHolder.ViewHolder;
import java.util.ArrayList;
import java.util.List;

public abstract class RecyclingPagerAdapter<VH extends ViewHolder>
extends PagerAdapter {
    private static final String STATE = RecyclingPagerAdapter.class.getSimpleName();
    private static final String TAG = RecyclingPagerAdapter.class.getSimpleName();
    public static boolean DEBUG = false;
    private SparseArray<RecycleCache> mRecycleTypeCaches = new SparseArray();
    private SparseArray<Parcelable> mSavedStates = new SparseArray();

    public abstract int getItemCount();

    public abstract void onBindViewHolder(VH var1, int var2);

    public abstract VH onCreateViewHolder(ViewGroup var1, int var2);

    public void destroyItem(ViewGroup parent, int position, Object object) {
        if (object instanceof ViewHolder) {
            ((ViewHolder)object).detach(parent);
        }
    }

    public int getCount() {
        return this.getItemCount();
    }

    public int getItemPosition(Object object) {
        return -2;
    }

    public Object instantiateItem(ViewGroup parent, int position) {
        int viewType = this.getItemViewType(position);
        if (this.mRecycleTypeCaches.get(viewType) == null) {
            this.mRecycleTypeCaches.put(viewType, (Object)new RecycleCache(this));
        }
        ViewHolder viewHolder = ((RecycleCache)this.mRecycleTypeCaches.get(viewType)).getFreeViewHolder(parent, viewType);
        viewHolder.attach(parent, position);
        this.onBindViewHolder(viewHolder, position);
        viewHolder.onRestoreInstanceState((Parcelable)this.mSavedStates.get(this.getItemId(position)));
        return viewHolder;
    }

    public boolean isViewFromObject(View view, Object object) {
        return object instanceof ViewHolder && ((ViewHolder)object).itemView == view;
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        for (ViewHolder viewHolder : this.getAttachedViewHolders()) {
            this.onNotifyItemChanged(viewHolder);
        }
    }

    public void restoreState(Parcelable state, ClassLoader loader) {
        if (state instanceof Bundle) {
            Bundle bundle = (Bundle)state;
            bundle.setClassLoader(loader);
            SparseArray ss = bundle.containsKey(STATE) ? bundle.getSparseParcelableArray(STATE) : null;
            this.mSavedStates = ss != null ? ss : new SparseArray();
        }
        super.restoreState(state, loader);
    }

    public Parcelable saveState() {
        Bundle bundle = new Bundle();
        for (ViewHolder viewHolder : this.getAttachedViewHolders()) {
            this.mSavedStates.put(this.getItemId(viewHolder.mPosition), (Object)viewHolder.onSaveInstanceState());
        }
        bundle.putSparseParcelableArray(STATE, this.mSavedStates);
        return bundle;
    }

    public int getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        return 0;
    }

    protected void onNotifyItemChanged(ViewHolder viewHolder) {
    }

    private List<ViewHolder> getAttachedViewHolders() {
        ArrayList<ViewHolder> attachedViewHolders = new ArrayList<ViewHolder>();
        int n = this.mRecycleTypeCaches.size();
        for (int i = 0; i < n; ++i) {
            for (ViewHolder viewHolder : ((RecycleCache)this.mRecycleTypeCaches.get(this.mRecycleTypeCaches.keyAt(i))).mCaches) {
                if (!viewHolder.mIsAttached) continue;
                attachedViewHolders.add(viewHolder);
            }
        }
        return attachedViewHolders;
    }

    private static class RecycleCache {
        private final RecyclingPagerAdapter mAdapter;
        private final List<ViewHolder> mCaches;

        RecycleCache(RecyclingPagerAdapter adapter) {
            this.mAdapter = adapter;
            this.mCaches = new ArrayList<ViewHolder>();
        }

        ViewHolder getFreeViewHolder(ViewGroup parent, int viewType) {
            ViewHolder viewHolder;
            int n = this.mCaches.size();
            for (int i = 0; i < n; ++i) {
                viewHolder = this.mCaches.get(i);
                if (viewHolder.mIsAttached) continue;
                return viewHolder;
            }
            viewHolder = this.mAdapter.onCreateViewHolder(parent, viewType);
            this.mCaches.add(viewHolder);
            return viewHolder;
        }
    }
}

