/*
 * Decompiled with CFR 0.152.
 */
package com.example.bxlargeimageviewer.ViewHolder;

import android.os.Bundle;
import android.os.Parcelable;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;

public abstract class ViewHolder {
    private static final String STATE = ViewHolder.class.getSimpleName();
    public final View itemView;
    public boolean mIsAttached;
    public int mPosition;

    public ViewHolder(View itemView) {
        if (itemView == null) {
            throw new IllegalArgumentException("itemView should not be null");
        }
        this.itemView = itemView;
    }

    public void attach(ViewGroup parent, int position) {
        this.mIsAttached = true;
        this.mPosition = position;
        parent.addView(this.itemView);
    }

    public void detach(ViewGroup parent) {
        parent.removeView(this.itemView);
        this.mIsAttached = false;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (state instanceof Bundle) {
            SparseArray ss;
            Bundle bundle = (Bundle)state;
            SparseArray sparseArray = ss = bundle.containsKey(STATE) ? bundle.getSparseParcelableArray(STATE) : null;
            if (ss != null) {
                this.itemView.restoreHierarchyState(ss);
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        SparseArray state = new SparseArray();
        this.itemView.saveHierarchyState(state);
        Bundle bundle = new Bundle();
        bundle.putSparseParcelableArray(STATE, state);
        return bundle;
    }
}

