/*
 * Decompiled with CFR 0.152.
 */
package com.example.bxlargeimageviewer.ViewHolder;

import android.content.Context;
import android.graphics.drawable.Animatable;
import android.view.View;
import android.widget.ProgressBar;
import com.example.bxlargeimageviewer.Drawee.ZoomableDraweeView;
import com.example.bxlargeimageviewer.R;
import com.example.bxlargeimageviewer.Utils.BXUtils;
import com.example.bxlargeimageviewer.ViewHolder.ViewHolder;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.backends.pipeline.PipelineDraweeControllerBuilder;
import com.facebook.drawee.controller.BaseControllerListener;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.imagepipeline.image.ImageInfo;
import java.util.List;

public class PagerViewHolder
extends ViewHolder {
    ZoomableDraweeView simpleDraweeView;
    ProgressBar progressBar;
    Context context;
    List<String> imageURIs;

    public PagerViewHolder(View itemView, List<String> imageURIs) {
        super(itemView);
        this.context = itemView.getContext();
        this.simpleDraweeView = (ZoomableDraweeView)itemView.findViewById(R.id.image_view);
        this.progressBar = (ProgressBar)itemView.findViewById(R.id.progress_bar_view);
        this.imageURIs = imageURIs;
    }

    public void onBind(int position, int progressBarColor) {
        BXUtils.setProgressBarColor(this.progressBar, progressBarColor);
        this.progressBar.setVisibility(0);
        PipelineDraweeControllerBuilder builder = Fresco.newDraweeControllerBuilder();
        String path = this.imageURIs.get(position);
        builder.setUri(path);
        builder.setAutoPlayAnimations(true);
        builder.setControllerListener(this.getDraweeControllerListener(this.simpleDraweeView));
        this.simpleDraweeView.setController((DraweeController)builder.build());
    }

    private BaseControllerListener<ImageInfo> getDraweeControllerListener(final ZoomableDraweeView drawee) {
        return new BaseControllerListener<ImageInfo>(){

            public void onFinalImageSet(String id2, ImageInfo imageInfo, Animatable animatable) {
                super.onFinalImageSet(id2, (Object)imageInfo, animatable);
                if (imageInfo == null) {
                    return;
                }
                drawee.update(imageInfo.getWidth(), imageInfo.getHeight());
                PagerViewHolder.this.progressBar.setVisibility(8);
            }

            public void onFailure(String id2, Throwable throwable) {
                super.onFailure(id2, throwable);
                drawee.setImageURI(BXUtils.getUriOfResourceImage(R.drawable.no_images));
                PagerViewHolder.this.progressBar.setVisibility(8);
            }
        };
    }
}

