/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.PartyAddressRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.TransferRequest;
import java.util.Calendar;

public class PartyRequest
extends Request {
    private String accountReferenceNumber;
    private PartyAddressRequest address;
    private Calendar dateOfBirth;
    private String firstName;
    private String lastName;
    private String middleName;
    private String taxId;
    private TransferRequest parent;
    private String tagName = "party";

    public PartyRequest(TransferRequest parent, String tagName) {
        this.parent = parent;
        this.tagName = tagName;
    }

    public PartyRequest(TransferRequest parent) {
        this.parent = parent;
    }

    public PartyRequest accountReferenceNumber(String accountReferenceNumber) {
        this.accountReferenceNumber = accountReferenceNumber;
        return this;
    }

    public PartyAddressRequest address() {
        this.address = new PartyAddressRequest(this);
        return this.address;
    }

    public PartyRequest dateOfBirth(Calendar dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
        return this;
    }

    public PartyRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public PartyRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public PartyRequest middleName(String middleName) {
        this.middleName = middleName;
        return this;
    }

    public PartyRequest taxId(String taxId) {
        this.taxId = taxId;
        return this;
    }

    public TransferRequest done() {
        return this.parent;
    }

    @Override
    public String toXML() {
        return this.buildRequest(this.tagName).toXML();
    }

    @Override
    public String toQueryString() {
        return this.toQueryString(this.tagName);
    }

    @Override
    public String toQueryString(String root) {
        return this.buildRequest(root).toQueryString();
    }

    protected RequestBuilder buildRequest(String root) {
        RequestBuilder builder = new RequestBuilder(root);
        if (this.accountReferenceNumber != null) {
            builder.addElement("accountReferenceNumber", this.accountReferenceNumber);
        }
        if (this.address != null) {
            builder.addElement("address", this.address);
        }
        if (this.dateOfBirth != null) {
            builder.addElement("dateOfBirth", this.dateOfBirth);
        }
        if (this.firstName != null) {
            builder.addElement("firstName", this.firstName);
        }
        if (this.lastName != null) {
            builder.addElement("lastName", this.lastName);
        }
        if (this.middleName != null) {
            builder.addElement("middleName", this.middleName);
        }
        if (this.taxId != null) {
            builder.addElement("taxId", this.taxId);
        }
        return builder;
    }
}

