/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.BlikAlias;
import com.braintreegateway.Transaction;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.List;

public class LocalPaymentCompleted {
    private String bic;
    private List<BlikAlias> blikAliases;
    private String ibanLastChars;
    private String payerId;
    private String payerName;
    private String paymentId;
    private String paymentMethodNonce;
    private Transaction transaction;

    public LocalPaymentCompleted(NodeWrapper node) {
        this.bic = node.findString("bic");
        this.ibanLastChars = node.findString("iban-last-chars");
        this.payerId = node.findString("payer-id");
        this.payerName = node.findString("payer-name");
        this.paymentId = node.findString("payment-id");
        this.paymentMethodNonce = node.findString("payment-method-nonce");
        NodeWrapper transactionNode = node.findFirst("transaction");
        if (transactionNode != null) {
            this.transaction = new Transaction(transactionNode);
        }
        this.blikAliases = new ArrayList<BlikAlias>();
        for (NodeWrapper blikAliasNode : node.findAll("blik-aliases/blik-alias")) {
            this.blikAliases.add(new BlikAlias(blikAliasNode));
        }
    }

    public String getBic() {
        return this.bic;
    }

    public List<BlikAlias> getBlikAlias() {
        return this.blikAliases;
    }

    public String getIbanLastChars() {
        return this.ibanLastChars;
    }

    public String getPayerId() {
        return this.payerId;
    }

    public String getPayerName() {
        return this.payerName;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public String getPaymentMethodNonce() {
        return this.paymentMethodNonce;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }
}

