/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway.graphql.inputs;

import com.braintreegateway.Request;
import com.braintreegateway.graphql.inputs.CustomerSessionInput;
import com.braintreegateway.graphql.inputs.PayPalPurchaseUnitInput;
import com.braintreegateway.util.Experimental;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Experimental(value="This class is experimental and may change in future releases.")
public class UpdateCustomerSessionInput
extends Request {
    private final String merchantAccountId;
    private final String sessionId;
    private final CustomerSessionInput customer;
    private final List<PayPalPurchaseUnitInput> purchaseUnits;

    private UpdateCustomerSessionInput(Builder builder) {
        this.merchantAccountId = builder.merchantAccountId;
        this.sessionId = builder.sessionId;
        this.customer = builder.customer;
        this.purchaseUnits = builder.purchaseUnits;
    }

    @Override
    public Map<String, Object> toGraphQLVariables() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("merchantAccountId", this.merchantAccountId);
        if (this.purchaseUnits != null && !this.purchaseUnits.isEmpty()) {
            ArrayList<Map<String, Object>> formattedPurchaseUnits = new ArrayList<Map<String, Object>>();
            for (PayPalPurchaseUnitInput purchaseUnit : this.purchaseUnits) {
                formattedPurchaseUnits.add(purchaseUnit.toGraphQLVariables());
            }
            variables.put("purchaseUnits", formattedPurchaseUnits);
        }
        variables.put("sessionId", this.sessionId);
        if (this.customer != null) {
            variables.put("customer", this.customer.toGraphQLVariables());
        }
        return variables;
    }

    public static Builder builder(String sessionId) {
        return new Builder(sessionId);
    }

    public static class Builder {
        private String merchantAccountId;
        private String sessionId;
        private CustomerSessionInput customer;
        private List<PayPalPurchaseUnitInput> purchaseUnits;

        public Builder(String sessionId) {
            this.sessionId = sessionId;
        }

        public Builder merchantAccountId(String merchantAccountId) {
            this.merchantAccountId = merchantAccountId;
            return this;
        }

        public Builder customer(CustomerSessionInput customer) {
            this.customer = customer;
            return this;
        }

        public Builder purchaseUnits(List<PayPalPurchaseUnitInput> purchaseUnits) {
            this.purchaseUnits = purchaseUnits;
            return this;
        }

        public UpdateCustomerSessionInput build() {
            return new UpdateCustomerSessionInput(this);
        }
    }
}

