/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;

public class TransactionLineItem {
    private Kind kind;
    private BigDecimal discountAmount;
    private BigDecimal quantity;
    private BigDecimal taxAmount;
    private BigDecimal totalAmount;
    private BigDecimal unitAmount;
    private BigDecimal unitTaxAmount;
    private String commodityCode;
    private String description;
    private String imageUrl;
    private String name;
    private String productCode;
    private String unitOfMeasure;
    private String upcCode;
    private String upcType;
    private String url;

    public TransactionLineItem(NodeWrapper node) {
        this.commodityCode = node.findString("commodity-code");
        this.description = node.findString("description");
        this.discountAmount = node.findBigDecimal("discount-amount");
        this.imageUrl = node.findString("image-url");
        this.kind = EnumUtils.findByName(Kind.class, node.findString("kind"), Kind.UNRECOGNIZED);
        this.name = node.findString("name");
        this.productCode = node.findString("product-code");
        this.quantity = node.findBigDecimal("quantity");
        this.taxAmount = node.findBigDecimal("tax-amount");
        this.totalAmount = node.findBigDecimal("total-amount");
        this.unitAmount = node.findBigDecimal("unit-amount");
        this.unitOfMeasure = node.findString("unit-of-measure");
        this.unitTaxAmount = node.findBigDecimal("unit-tax-amount");
        this.upcCode = node.findString("upc-code");
        this.upcType = node.findString("upc-type");
        this.url = node.findString("url");
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Kind getKind() {
        return this.kind;
    }

    public BigDecimal getUnitAmount() {
        return this.unitAmount;
    }

    public BigDecimal getUnitTaxAmount() {
        return this.unitTaxAmount;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public String getCommodityCode() {
        return this.commodityCode;
    }

    public String getUrl() {
        return this.url;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getUpcCode() {
        return this.upcCode;
    }

    public String getUpcType() {
        return this.upcType;
    }

    public static enum Kind {
        DEBIT("debit"),
        CREDIT("credit"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private Kind(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

