/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AndroidPayCardRequest;
import com.braintreegateway.AndroidPayNetworkTokenRequest;
import com.braintreegateway.ApplePayCardRequest;
import com.braintreegateway.CreditCardRequest;
import com.braintreegateway.CustomerOptionsRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;
import com.braintreegateway.RiskDataCustomerRequest;
import com.braintreegateway.TaxIdentifierRequest;
import com.braintreegateway.TransactionRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomerRequest
extends Request {
    private String company;
    private String customerId;
    private String defaultPaymentMethodToken;
    private String deviceData;
    private String deviceSessionId;
    private String email;
    private String fax;
    private String firstName;
    private String fraudMerchantId;
    private String id;
    private String lastName;
    private String paymentMethodNonce;
    private String phone;
    private String threeDSecureAuthenticationId;
    private String website;
    private AndroidPayCardRequest androidPayCardRequest;
    private AndroidPayNetworkTokenRequest androidPayNetworkTokenRequest;
    private ApplePayCardRequest applePayCardRequest;
    private CreditCardRequest creditCardRequest;
    private CustomerOptionsRequest optionsRequest;
    private List<TaxIdentifierRequest> taxIdentifierRequests;
    private Map<String, String> customFields = new HashMap<String, String>();
    private RiskDataCustomerRequest riskDataCustomerRequest;
    private TransactionRequest parent;

    public CustomerRequest() {
        this.taxIdentifierRequests = new ArrayList<TaxIdentifierRequest>();
    }

    public CustomerRequest(TransactionRequest transactionRequest) {
        this();
        this.parent = transactionRequest;
    }

    public AndroidPayCardRequest androidPayCard() {
        this.androidPayCardRequest = new AndroidPayCardRequest(this);
        return this.androidPayCardRequest;
    }

    public AndroidPayNetworkTokenRequest androidPayNetworkToken() {
        this.androidPayNetworkTokenRequest = new AndroidPayNetworkTokenRequest(this);
        return this.androidPayNetworkTokenRequest;
    }

    public ApplePayCardRequest applePayCard() {
        this.applePayCardRequest = new ApplePayCardRequest(this);
        return this.applePayCardRequest;
    }

    public CreditCardRequest creditCard() {
        this.creditCardRequest = new CreditCardRequest(this);
        return this.creditCardRequest;
    }

    public CustomerRequest company(String company) {
        this.company = company;
        return this;
    }

    public CustomerRequest customerId(String customerId) {
        this.customerId = customerId;
        return this;
    }

    public CustomerRequest customField(String apiName, String value) {
        this.customFields.put(apiName, value);
        return this;
    }

    public CustomerRequest defaultPaymentMethodToken(String token) {
        this.defaultPaymentMethodToken = token;
        return this;
    }

    public CustomerRequest deviceData(String deviceData) {
        this.deviceData = deviceData;
        return this;
    }

    @Deprecated
    public CustomerRequest deviceSessionId(String deviceSessionId) {
        this.deviceSessionId = deviceSessionId;
        return this;
    }

    public CustomerRequest email(String email) {
        this.email = email;
        return this;
    }

    public CustomerRequest fax(String fax) {
        this.fax = fax;
        return this;
    }

    public CustomerRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Deprecated
    public CustomerRequest fraudMerchantId(String fraudMerchantId) {
        this.fraudMerchantId = fraudMerchantId;
        return this;
    }

    public CustomerRequest id(String id) {
        this.id = id;
        return this;
    }

    public CustomerRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public CustomerRequest paymentMethodNonce(String nonce) {
        this.paymentMethodNonce = nonce;
        return this;
    }

    public CustomerRequest phone(String phone) {
        this.phone = phone;
        return this;
    }

    public CustomerRequest website(String website) {
        this.website = website;
        return this;
    }

    public CustomerOptionsRequest options() {
        this.optionsRequest = new CustomerOptionsRequest(this);
        return this.optionsRequest;
    }

    public RiskDataCustomerRequest riskData() {
        this.riskDataCustomerRequest = new RiskDataCustomerRequest(this);
        return this.riskDataCustomerRequest;
    }

    public String getId() {
        return this.id;
    }

    public CustomerRequest threeDSecureAuthenticationId(String threeDSecureAuthenticationId) {
        this.threeDSecureAuthenticationId = threeDSecureAuthenticationId;
        return this;
    }

    public TaxIdentifierRequest taxIdentifier() {
        TaxIdentifierRequest taxIdentiferRequest = new TaxIdentifierRequest(this);
        this.taxIdentifierRequests.add(taxIdentiferRequest);
        return taxIdentiferRequest;
    }

    public TransactionRequest done() {
        return this.parent;
    }

    @Override
    public String toXML() {
        return this.buildRequest("customer").toXML();
    }

    @Override
    public String toQueryString() {
        return this.toQueryString("customer");
    }

    @Override
    public String toQueryString(String root) {
        return this.buildRequest(root).addTopLevelElement("customerId", this.customerId).toQueryString();
    }

    protected RequestBuilder buildRequest(String root) {
        RequestBuilder builder = new RequestBuilder(root).addElement("androidPayCard", this.androidPayCardRequest).addElement("androidPayNetworkToken", this.androidPayNetworkTokenRequest).addElement("applePayCard", this.applePayCardRequest).addElement("company", this.company).addElement("creditCard", this.creditCardRequest).addElement("defaultPaymentMethodToken", this.defaultPaymentMethodToken).addElement("deviceData", this.deviceData).addElement("email", this.email).addElement("fax", this.fax).addElement("firstName", this.firstName).addElement("id", this.id).addElement("lastName", this.lastName).addElement("options", this.optionsRequest).addElement("paymentMethodNonce", this.paymentMethodNonce).addElement("phone", this.phone).addElement("riskData", this.riskDataCustomerRequest).addElement("threeDSecureAuthenticationId", this.threeDSecureAuthenticationId).addElement("website", this.website);
        if (this.customFields.size() > 0) {
            builder.addElement("customFields", this.customFields);
        }
        if (!this.taxIdentifierRequests.isEmpty()) {
            builder.addElement("taxIdentifiers", this.taxIdentifierRequests);
        }
        return builder;
    }
}

