/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.IndividualAddressRequest;
import com.braintreegateway.MerchantAccountRequest;
import com.braintreegateway.Request;
import com.braintreegateway.RequestBuilder;

public class IndividualRequest
extends Request {
    private String firstName;
    private String lastName;
    private String email;
    private String phone;
    private IndividualAddressRequest address;
    private String dateOfBirth;
    private String ssn;
    private MerchantAccountRequest parent;

    public IndividualRequest(MerchantAccountRequest parent) {
        this.parent = parent;
    }

    public IndividualRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    public IndividualRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    public IndividualRequest email(String email) {
        this.email = email;
        return this;
    }

    public IndividualRequest phone(String phone) {
        this.phone = phone;
        return this;
    }

    public IndividualAddressRequest address() {
        this.address = new IndividualAddressRequest(this);
        return this.address;
    }

    public IndividualRequest dateOfBirth(String dob) {
        this.dateOfBirth = dob;
        return this;
    }

    public IndividualRequest ssn(String ssn) {
        this.ssn = ssn;
        return this;
    }

    public MerchantAccountRequest done() {
        return this.parent;
    }

    public String toQueryString() {
        return this.toQueryString("individual");
    }

    public String toQueryString(String root) {
        return this.buildRequest(root).toQueryString();
    }

    public String toXML() {
        return this.buildRequest("individual").toXML();
    }

    protected RequestBuilder buildRequest(String root) {
        return new RequestBuilder(root).addElement("firstName", this.firstName).addElement("lastName", this.lastName).addElement("email", this.email).addElement("phone", this.phone).addElement("addressRequest", this.address).addElement("dateOfBirth", this.dateOfBirth).addElement("ssn", this.ssn);
    }
}

