/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Pager;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceCollection<T>
implements Iterable<T> {
    private List<String> ids;
    private Pager<T> pager;
    private int pageSize;

    public ResourceCollection(Pager<T> pager, NodeWrapper response) {
        this.pager = pager;
        this.pageSize = response.findInteger("page-size");
        this.ids = response.findAllStrings("ids/*");
    }

    public int getMaximumSize() {
        return this.ids.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new PagedIterator(this);
    }

    public T getFirst() {
        return this.pager.getPage(this.ids.subList(0, 1)).get(0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PagedIterator<E>
    implements Iterator<E> {
        private ResourceCollection<E> resourceCollection;
        private List<String> ids;
        private int pageSize;
        private int index;
        private int nextIndexToFetch;
        private List<E> items;

        public PagedIterator(ResourceCollection<E> resourceCollection2) {
            this.resourceCollection = resourceCollection2;
            this.ids = ((ResourceCollection)resourceCollection2).ids;
            this.pageSize = ((ResourceCollection)resourceCollection2).pageSize;
            this.index = 0;
            this.nextIndexToFetch = 0;
            this.items = new ArrayList();
        }

        private List<String> nextBatchOfIds() {
            int lastIdIndex = this.nextIndexToFetch + this.pageSize;
            if (lastIdIndex > this.ids.size()) {
                lastIdIndex = this.ids.size();
            }
            List<String> nextIds = this.ids.subList(this.nextIndexToFetch, lastIdIndex);
            this.nextIndexToFetch = lastIdIndex;
            return nextIds;
        }

        @Override
        public boolean hasNext() {
            if (this.nextIndexToFetch < this.ids.size() && this.index == this.items.size()) {
                this.items = ((ResourceCollection)this.resourceCollection).pager.getPage(this.nextBatchOfIds());
                this.index = 0;
            }
            return this.index < this.items.size();
        }

        @Override
        public E next() {
            E item = this.items.get(this.index);
            ++this.index;
            return item;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

