/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.TransactionDetails;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.Calendar;

public final class Dispute {
    private final Calendar receivedDate;
    private final Calendar replyByDate;
    private final String currencyIsoCode;
    private final String id;
    private final Reason reason;
    private final Status status;
    private final BigDecimal amount;
    private final TransactionDetails transactionDetails;

    public Dispute(NodeWrapper node) {
        this.receivedDate = node.findDate("received-date");
        this.replyByDate = node.findDate("reply-by-date");
        this.currencyIsoCode = node.findString("currency-iso-code");
        this.reason = EnumUtils.findByName(Reason.class, node.findString("reason"));
        this.status = EnumUtils.findByName(Status.class, node.findString("status"));
        this.amount = node.findBigDecimal("amount");
        this.id = node.findString("id");
        this.transactionDetails = new TransactionDetails(node.findFirst("transaction"));
    }

    public Calendar getReceivedDate() {
        return this.receivedDate;
    }

    public Calendar getReplyByDate() {
        return this.replyByDate;
    }

    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public String getId() {
        return this.id;
    }

    public Reason getReason() {
        return this.reason;
    }

    public Status getStatus() {
        return this.status;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public TransactionDetails getTransactionDetails() {
        return this.transactionDetails;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Reason {
        CANCELLED_RECURRING_TRANSACTION,
        CREDIT_NOT_PROCESSED,
        DUPLICATE,
        FRAUD,
        GENERAL,
        INVALID_ACCOUNT,
        NOT_RECOGNIZED,
        PRODUCT_NOT_RECEIVED,
        PRODUCT_UNSATISFACTORY,
        TRANSACTION_AMOUNT_DIFFERS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OPEN,
        LOST,
        WON;

    }
}

