/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.CreditCard;
import com.braintreegateway.PayPalAccount;
import com.braintreegateway.PaymentMethod;
import com.braintreegateway.PaymentMethodRequest;
import com.braintreegateway.Result;
import com.braintreegateway.SEPABankAccount;
import com.braintreegateway.UnknownPaymentMethod;
import com.braintreegateway.exceptions.NotFoundException;
import com.braintreegateway.util.Http;
import com.braintreegateway.util.NodeWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaymentMethodGateway {
    private Http http;

    public PaymentMethodGateway(Http http) {
        this.http = http;
    }

    public Result<? extends PaymentMethod> create(PaymentMethodRequest request) {
        NodeWrapper response = this.http.post("/payment_methods", request);
        return this.parseResponse(response);
    }

    public Result<? extends PaymentMethod> update(String token, PaymentMethodRequest request) {
        NodeWrapper response = this.http.put("/payment_methods/any/" + token, request);
        return this.parseResponse(response);
    }

    public Result<? extends PaymentMethod> delete(String token) {
        this.http.delete("/payment_methods/any/" + token);
        return new Result();
    }

    public PaymentMethod find(String token) {
        if (token == null || token.trim().equals("")) {
            throw new NotFoundException();
        }
        NodeWrapper response = this.http.get("/payment_methods/any/" + token);
        if (response.getElementName() == "paypal-account") {
            return new PayPalAccount(response);
        }
        if (response.getElementName() == "credit-card") {
            return new CreditCard(response);
        }
        if (response.getElementName() == "sepa-bank-account") {
            return new SEPABankAccount(response);
        }
        return new UnknownPaymentMethod(response);
    }

    public Result<? extends PaymentMethod> parseResponse(NodeWrapper response) {
        if (response.getElementName() == "paypal-account") {
            return new Result<PayPalAccount>(response, PayPalAccount.class);
        }
        if (response.getElementName() == "credit-card") {
            return new Result<CreditCard>(response, CreditCard.class);
        }
        if (response.getElementName() == "sepa-bank-account") {
            return new Result<SEPABankAccount>(response, SEPABankAccount.class);
        }
        return new Result<UnknownPaymentMethod>(response, UnknownPaymentMethod.class);
    }
}

