/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.AddOn;
import com.braintreegateway.Address;
import com.braintreegateway.BraintreeGateway;
import com.braintreegateway.CreditCard;
import com.braintreegateway.Customer;
import com.braintreegateway.Descriptor;
import com.braintreegateway.DisbursementDetails;
import com.braintreegateway.Discount;
import com.braintreegateway.StatusEvent;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transaction {
    private List<AddOn> addOns;
    private BigDecimal amount;
    private String avsErrorResponseCode;
    private String avsPostalCodeResponseCode;
    private String avsStreetAddressResponseCode;
    private Address billingAddress;
    private String channel;
    private Calendar createdAt;
    private CreditCard creditCard;
    private String currencyIsoCode;
    private Customer customer;
    private Map<String, String> customFields;
    private String cvvResponseCode;
    private DisbursementDetails disbursementDetails;
    private Descriptor descriptor;
    private List<Discount> discounts;
    private EscrowStatus escrowStatus;
    private GatewayRejectionReason gatewayRejectionReason;
    private String id;
    private String merchantAccountId;
    private String orderId;
    private String planId;
    private String processorAuthorizationCode;
    private String processorResponseCode;
    private String processorResponseText;
    private String purchaseOrderNumber;
    private Boolean recurring;
    private String refundedTransactionId;
    private String refundId;
    private List<String> refundIds;
    private String settlementBatchId;
    private Address shippingAddress;
    private Status status;
    private List<StatusEvent> statusHistory;
    private String subscriptionId;
    private Subscription subscription;
    private BigDecimal taxAmount;
    private Boolean taxExempt;
    private Type type;
    private Calendar updatedAt;
    private BigDecimal serviceFeeAmount;

    public boolean isDisbursed() {
        return this.getDisbursementDetails().isValid();
    }

    public Transaction(NodeWrapper node) {
        this.amount = node.findBigDecimal("amount");
        this.avsErrorResponseCode = node.findString("avs-error-response-code");
        this.avsPostalCodeResponseCode = node.findString("avs-postal-code-response-code");
        this.avsStreetAddressResponseCode = node.findString("avs-street-address-response-code");
        this.billingAddress = new Address(node.findFirst("billing"));
        this.channel = node.findString("channel");
        this.createdAt = node.findDateTime("created-at");
        this.creditCard = new CreditCard(node.findFirst("credit-card"));
        this.currencyIsoCode = node.findString("currency-iso-code");
        this.customFields = node.findMap("custom-fields/*");
        this.customer = new Customer(node.findFirst("customer"));
        this.cvvResponseCode = node.findString("cvv-response-code");
        this.disbursementDetails = new DisbursementDetails(node.findFirst("disbursement-details"));
        this.descriptor = new Descriptor(node.findFirst("descriptor"));
        this.escrowStatus = EnumUtils.findByName(EscrowStatus.class, node.findString("escrow-status"));
        this.gatewayRejectionReason = EnumUtils.findByName(GatewayRejectionReason.class, node.findString("gateway-rejection-reason"));
        this.id = node.findString("id");
        this.merchantAccountId = node.findString("merchant-account-id");
        this.orderId = node.findString("order-id");
        this.planId = node.findString("plan-id");
        this.processorAuthorizationCode = node.findString("processor-authorization-code");
        this.processorResponseCode = node.findString("processor-response-code");
        this.processorResponseText = node.findString("processor-response-text");
        this.purchaseOrderNumber = node.findString("purchase-order-number");
        this.recurring = node.findBoolean("recurring");
        this.refundedTransactionId = node.findString("refunded-transaction-id");
        this.refundId = node.findString("refund-id");
        this.serviceFeeAmount = node.findBigDecimal("service-fee-amount");
        this.settlementBatchId = node.findString("settlement-batch-id");
        this.shippingAddress = new Address(node.findFirst("shipping"));
        this.status = EnumUtils.findByName(Status.class, node.findString("status"));
        this.subscription = new Subscription(node.findFirst("subscription"));
        this.subscriptionId = node.findString("subscription-id");
        this.taxAmount = node.findBigDecimal("tax-amount");
        this.taxExempt = node.findBoolean("tax-exempt");
        this.type = EnumUtils.findByName(Type.class, node.findString("type"));
        this.updatedAt = node.findDateTime("updated-at");
        this.refundIds = new ArrayList<String>();
        for (NodeWrapper refundIdNode : node.findAll("refund-ids/item")) {
            this.refundIds.add(refundIdNode.findString("."));
        }
        this.statusHistory = new ArrayList<StatusEvent>();
        for (NodeWrapper statusNode : node.findAll("status-history/status-event")) {
            this.statusHistory.add(new StatusEvent(statusNode));
        }
        this.addOns = new ArrayList<AddOn>();
        for (NodeWrapper addOnResponse : node.findAll("add-ons/add-on")) {
            this.addOns.add(new AddOn(addOnResponse));
        }
        this.discounts = new ArrayList<Discount>();
        for (NodeWrapper discountResponse : node.findAll("discounts/discount")) {
            this.discounts.add(new Discount(discountResponse));
        }
    }

    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getAvsErrorResponseCode() {
        return this.avsErrorResponseCode;
    }

    public String getAvsPostalCodeResponseCode() {
        return this.avsPostalCodeResponseCode;
    }

    public String getAvsStreetAddressResponseCode() {
        return this.avsStreetAddressResponseCode;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public String getChannel() {
        return this.channel;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public CreditCard getCreditCard() {
        return this.creditCard;
    }

    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public Map<String, String> getCustomFields() {
        return this.customFields;
    }

    public String getCvvResponseCode() {
        return this.cvvResponseCode;
    }

    public DisbursementDetails getDisbursementDetails() {
        return this.disbursementDetails;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public List<Discount> getDiscounts() {
        return this.discounts;
    }

    public EscrowStatus getEscrowStatus() {
        return this.escrowStatus;
    }

    public GatewayRejectionReason getGatewayRejectionReason() {
        return this.gatewayRejectionReason;
    }

    public String getId() {
        return this.id;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getPlanId() {
        return this.planId;
    }

    public String getProcessorAuthorizationCode() {
        return this.processorAuthorizationCode;
    }

    public String getProcessorResponseCode() {
        return this.processorResponseCode;
    }

    public String getProcessorResponseText() {
        return this.processorResponseText;
    }

    public String getPurchaseOrderNumber() {
        return this.purchaseOrderNumber;
    }

    public String getRefundedTransactionId() {
        return this.refundedTransactionId;
    }

    @Deprecated
    public String getRefundId() {
        return this.refundId;
    }

    public List<String> getRefundIds() {
        return this.refundIds;
    }

    public BigDecimal getServiceFeeAmount() {
        return this.serviceFeeAmount;
    }

    public String getSettlementBatchId() {
        return this.settlementBatchId;
    }

    public Address getShippingAddress() {
        return this.shippingAddress;
    }

    public Status getStatus() {
        return this.status;
    }

    public List<StatusEvent> getStatusHistory() {
        return this.statusHistory;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public Subscription getSubscription() {
        return this.subscription;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public Type getType() {
        return this.type;
    }

    public Boolean getRecurring() {
        return this.recurring;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    public Address getVaultBillingAddress(BraintreeGateway gateway) {
        if (this.billingAddress.getId() == null) {
            return null;
        }
        return gateway.address().find(this.customer.getId(), this.billingAddress.getId());
    }

    public CreditCard getVaultCreditCard(BraintreeGateway gateway) {
        if (this.creditCard.getToken() == null) {
            return null;
        }
        return gateway.creditCard().find(this.creditCard.getToken());
    }

    public Customer getVaultCustomer(BraintreeGateway gateway) {
        if (this.customer.getId() == null) {
            return null;
        }
        return gateway.customer().find(this.customer.getId());
    }

    public Address getVaultShippingAddress(BraintreeGateway gateway) {
        if (this.shippingAddress.getId() == null) {
            return null;
        }
        return gateway.address().find(this.customer.getId(), this.shippingAddress.getId());
    }

    public Boolean isTaxExempt() {
        return this.taxExempt;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CREDIT("credit"),
        SALE("sale"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private Type(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        AUTHORIZATION_EXPIRED,
        AUTHORIZED,
        AUTHORIZING,
        FAILED,
        GATEWAY_REJECTED,
        PROCESSOR_DECLINED,
        SETTLED,
        SETTLING,
        SUBMITTED_FOR_SETTLEMENT,
        UNRECOGNIZED,
        VOIDED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Source {
        API("api"),
        CONTROL_PANEL("control_panel"),
        RECURRING("recurring"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private Source(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GatewayRejectionReason {
        AVS("avs"),
        AVS_AND_CVV("avs_and_cvv"),
        CVV("cvv"),
        DUPLICATE("duplicate"),
        FRAUD("fraud"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private GatewayRejectionReason(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EscrowStatus {
        HELD,
        HOLD_PENDING,
        RELEASE_PENDING,
        RELEASED,
        REFUNDED,
        UNRECOGNIZED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CreatedUsing {
        FULL_INFORMATION("full_information"),
        TOKEN("token"),
        UNRECOGNIZED("unrecognized");

        private final String name;

        private CreatedUsing(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

