/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.PaymentMethod;
import com.braintreegateway.Subscription;
import com.braintreegateway.util.NodeWrapper;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class PayPalAccount
implements PaymentMethod {
    private String email;
    private String token;
    private String billingAgreementId;
    private boolean isDefault;
    private String imageUrl;
    private String payerId;
    private String customerId;
    private Calendar createdAt;
    private Calendar updatedAt;
    private List<Subscription> subscriptions;
    private Calendar revokedAt;

    public PayPalAccount(NodeWrapper node) {
        this.email = node.findString("email");
        this.token = node.findString("token");
        this.billingAgreementId = node.findString("billing-agreement-id");
        this.isDefault = node.findBoolean("default");
        this.imageUrl = node.findString("image-url");
        this.payerId = node.findString("payer-id");
        this.customerId = node.findString("customer-id");
        this.createdAt = node.findDateTime("created-at");
        this.updatedAt = node.findDateTime("updated-at");
        this.subscriptions = new ArrayList<Subscription>();
        for (NodeWrapper subscriptionResponse : node.findAll("subscriptions/subscription")) {
            this.subscriptions.add(new Subscription(subscriptionResponse));
        }
        this.revokedAt = node.findDateTime("revoked-at");
    }

    public String getEmail() {
        return this.email;
    }

    @Override
    public String getToken() {
        return this.token;
    }

    public String getBillingAgreementId() {
        return this.billingAgreementId;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    @Override
    public String getImageUrl() {
        return this.imageUrl;
    }

    public String getPayerId() {
        return this.payerId;
    }

    @Override
    public String getCustomerId() {
        return this.customerId;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public Calendar getUpdatedAt() {
        return this.updatedAt;
    }

    @Override
    public List<Subscription> getSubscriptions() {
        return this.subscriptions;
    }

    public Calendar getRevokedAt() {
        return this.revokedAt;
    }
}

