/*
 * Decompiled with CFR 0.152.
 */
package com.braintreegateway;

import com.braintreegateway.Address;
import com.braintreegateway.CreditCard;
import com.braintreegateway.ProcessorResponseType;
import com.braintreegateway.RiskData;
import com.braintreegateway.ThreeDSecureInfo;
import com.braintreegateway.Transaction;
import com.braintreegateway.util.EnumUtils;
import com.braintreegateway.util.NodeWrapper;
import java.math.BigDecimal;
import java.util.Calendar;

public class CreditCardVerification {
    private BigDecimal amount;
    private String avsErrorResponseCode;
    private String avsPostalCodeResponseCode;
    private String avsStreetAddressResponseCode;
    private String currencyIsoCode;
    private String cvvResponseCode;
    private Transaction.GatewayRejectionReason gatewayRejectionReason;
    private String processorResponseCode;
    private String processorResponseText;
    private ProcessorResponseType processorResponseType;
    private String networkResponseCode;
    private String networkResponseText;
    private String merchantAccountId;
    private Status status;
    private String id;
    private CreditCard creditCard;
    private Address billingAddress;
    private Calendar createdAt;
    private RiskData riskData;
    private ThreeDSecureInfo threeDSecureInfo;

    public CreditCardVerification(NodeWrapper node) {
        NodeWrapper billingAddressNode;
        NodeWrapper creditCardNode;
        NodeWrapper threeDSecureInfoNode;
        this.amount = node.findBigDecimal("amount");
        this.avsErrorResponseCode = node.findString("avs-error-response-code");
        this.avsPostalCodeResponseCode = node.findString("avs-postal-code-response-code");
        this.avsStreetAddressResponseCode = node.findString("avs-street-address-response-code");
        this.currencyIsoCode = node.findString("currency-iso-code");
        this.cvvResponseCode = node.findString("cvv-response-code");
        this.gatewayRejectionReason = EnumUtils.findByName(Transaction.GatewayRejectionReason.class, node.findString("gateway-rejection-reason"), Transaction.GatewayRejectionReason.UNRECOGNIZED);
        this.processorResponseCode = node.findString("processor-response-code");
        this.processorResponseText = node.findString("processor-response-text");
        this.processorResponseType = EnumUtils.findByName(ProcessorResponseType.class, node.findString("processor-response-type"), ProcessorResponseType.UNRECOGNIZED);
        this.networkResponseCode = node.findString("network-response-code");
        this.networkResponseText = node.findString("network-response-text");
        this.merchantAccountId = node.findString("merchant-account-id");
        this.status = EnumUtils.findByName(Status.class, node.findString("status"), Status.UNRECOGNIZED);
        this.id = node.findString("id");
        NodeWrapper riskDataNode = node.findFirst("risk-data");
        if (riskDataNode != null) {
            this.riskData = new RiskData(riskDataNode);
        }
        if ((threeDSecureInfoNode = node.findFirst("three-d-secure-info")) != null && !threeDSecureInfoNode.isBlank()) {
            this.threeDSecureInfo = new ThreeDSecureInfo(threeDSecureInfoNode);
        }
        if ((creditCardNode = node.findFirst("credit-card")) != null) {
            this.creditCard = new CreditCard(creditCardNode);
        }
        if ((billingAddressNode = node.findFirst("billing")) != null) {
            this.billingAddress = new Address(billingAddressNode);
        }
        this.createdAt = node.findDateTime("created-at");
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getAvsErrorResponseCode() {
        return this.avsErrorResponseCode;
    }

    public String getAvsPostalCodeResponseCode() {
        return this.avsPostalCodeResponseCode;
    }

    public String getAvsStreetAddressResponseCode() {
        return this.avsStreetAddressResponseCode;
    }

    public Address getBillingAddress() {
        return this.billingAddress;
    }

    public Calendar getCreatedAt() {
        return this.createdAt;
    }

    public CreditCard getCreditCard() {
        return this.creditCard;
    }

    public String getCurrencyIsoCode() {
        return this.currencyIsoCode;
    }

    public String getCvvResponseCode() {
        return this.cvvResponseCode;
    }

    public String getId() {
        return this.id;
    }

    public RiskData getRiskData() {
        return this.riskData;
    }

    public ThreeDSecureInfo getThreeDSecureInfo() {
        return this.threeDSecureInfo;
    }

    public Transaction.GatewayRejectionReason getGatewayRejectionReason() {
        return this.gatewayRejectionReason;
    }

    public String getProcessorResponseCode() {
        return this.processorResponseCode;
    }

    public String getProcessorResponseText() {
        return this.processorResponseText;
    }

    public ProcessorResponseType getProcessorResponseType() {
        return this.processorResponseType;
    }

    public String getNetworkResponseCode() {
        return this.networkResponseCode;
    }

    public String getNetworkResponseText() {
        return this.networkResponseText;
    }

    public String getMerchantAccountId() {
        return this.merchantAccountId;
    }

    public Status getStatus() {
        return this.status;
    }

    public static enum Status {
        FAILED,
        GATEWAY_REJECTED,
        PROCESSOR_DECLINED,
        UNRECOGNIZED,
        VERIFIED;

    }
}

