/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.Scheduler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class ThreadScheduler
implements Scheduler {
    private final Handler mainThreadHandler;
    private final ExecutorService backgroundThreadService;

    ThreadScheduler() {
        this(new Handler(Looper.getMainLooper()), Executors.newCachedThreadPool());
    }

    @VisibleForTesting
    ThreadScheduler(Handler mainThreadHandler, ExecutorService backgroundThreadPool) {
        this.mainThreadHandler = mainThreadHandler;
        this.backgroundThreadService = backgroundThreadPool;
    }

    @Override
    public void runOnBackground(Runnable runnable) {
        this.backgroundThreadService.submit(runnable);
    }

    @Override
    public void runOnMain(Runnable runnable) {
        this.mainThreadHandler.post(runnable);
    }
}

