/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import androidx.annotation.VisibleForTesting;
import com.braintreepayments.api.HttpClientException;
import com.braintreepayments.api.HttpRequest;
import com.braintreepayments.api.HttpResponseCallback;
import com.braintreepayments.api.HttpResponseParser;
import com.braintreepayments.api.Scheduler;
import com.braintreepayments.api.SynchronousHttpClient;
import com.braintreepayments.api.ThreadScheduler;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;

class HttpClient {
    static final int NO_RETRY = 0;
    static final int RETRY_MAX_3_TIMES = 1;
    static final int MAX_RETRY_ATTEMPTS = 3;
    private final Scheduler scheduler;
    private final SynchronousHttpClient syncHttpClient;
    private final Map<URL, Integer> retryCountMap;

    protected HttpClient(SSLSocketFactory socketFactory, HttpResponseParser httpResponseParser) {
        this(new SynchronousHttpClient(socketFactory, httpResponseParser), new ThreadScheduler());
    }

    @VisibleForTesting
    HttpClient(SynchronousHttpClient syncHttpClient, Scheduler scheduler) {
        this.syncHttpClient = syncHttpClient;
        this.scheduler = scheduler;
        this.retryCountMap = new HashMap<URL, Integer>();
    }

    String sendRequest(HttpRequest request) throws Exception {
        return this.syncHttpClient.request(request);
    }

    void sendRequest(HttpRequest request, HttpResponseCallback callback) {
        this.sendRequest(request, 0, callback);
    }

    void sendRequest(HttpRequest request, int retryStrategy, HttpResponseCallback callback) {
        this.scheduleRequest(request, retryStrategy, callback);
    }

    private void scheduleRequest(final HttpRequest request, final int retryStrategy, final HttpResponseCallback callback) {
        this.resetRetryCount(request);
        this.scheduler.runOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    String responseBody = HttpClient.this.syncHttpClient.request(request);
                    HttpClient.this.notifySuccessOnMainThread(callback, responseBody);
                }
                catch (Exception e) {
                    switch (retryStrategy) {
                        case 0: {
                            HttpClient.this.notifyErrorOnMainThread(callback, e);
                            break;
                        }
                        case 1: {
                            HttpClient.this.retryGet(request, retryStrategy, callback);
                        }
                    }
                }
            }
        });
    }

    private void retryGet(HttpRequest request, int retryStrategy, HttpResponseCallback callback) {
        URL url = null;
        try {
            url = request.getURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            // empty catch block
        }
        if (url != null) {
            boolean shouldRetry;
            int retryCount = this.getNumRetriesSoFar(url);
            boolean bl = shouldRetry = retryCount + 1 < 3;
            if (shouldRetry) {
                this.scheduleRequest(request, retryStrategy, callback);
                this.retryCountMap.put(url, retryCount + 1);
            } else {
                String message = "Retry limit has been exceeded. Try again later.";
                HttpClientException retryLimitException = new HttpClientException(message);
                this.notifyErrorOnMainThread(callback, retryLimitException);
            }
        }
    }

    private int getNumRetriesSoFar(URL url) {
        Integer retryCount = this.retryCountMap.get(url);
        if (retryCount == null) {
            return 0;
        }
        return retryCount;
    }

    private void resetRetryCount(HttpRequest request) {
        URL url = null;
        try {
            url = request.getURL();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            // empty catch block
        }
        if (url != null) {
            this.retryCountMap.remove(url);
        }
    }

    private void notifySuccessOnMainThread(final HttpResponseCallback callback, final String responseBody) {
        if (callback != null) {
            this.scheduler.runOnMain(new Runnable(){

                @Override
                public void run() {
                    callback.onResult(responseBody, null);
                }
            });
        }
    }

    private void notifyErrorOnMainThread(final HttpResponseCallback callback, final Exception e) {
        if (callback != null) {
            this.scheduler.runOnMain(new Runnable(){

                @Override
                public void run() {
                    callback.onResult(null, e);
                }
            });
        }
    }
}

