/*
 * Decompiled with CFR 0.152.
 */
package com.braintreepayments.api;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.braintreepayments.api.BrowserSwitchRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class BrowserSwitchResult {
    private static final String KEY_STATUS = "status";
    private static final String KEY_DEEP_LINK_URL = "deepLinkUrl";
    private static final String KEY_BROWSER_SWITCH_REQUEST = "browserSwitchRequest";
    private final int status;
    private final Uri deepLinkUrl;
    private final BrowserSwitchRequest request;

    static BrowserSwitchResult fromJson(String json) throws JSONException {
        JSONObject jsonObject = new JSONObject(json);
        int status = jsonObject.getInt(KEY_STATUS);
        String deepLinkUrl = jsonObject.getString(KEY_DEEP_LINK_URL);
        String browserSwitchRequest = jsonObject.getString(KEY_BROWSER_SWITCH_REQUEST);
        return new BrowserSwitchResult(status, BrowserSwitchRequest.fromJson(browserSwitchRequest), Uri.parse((String)deepLinkUrl));
    }

    BrowserSwitchResult(int status, BrowserSwitchRequest request) {
        this(status, request, null);
    }

    BrowserSwitchResult(int status, BrowserSwitchRequest request, Uri deepLinkUrl) {
        this.status = status;
        this.request = request;
        this.deepLinkUrl = deepLinkUrl;
    }

    public int getStatus() {
        return this.status;
    }

    @Nullable
    public JSONObject getRequestMetadata() {
        return this.request.getMetadata();
    }

    public int getRequestCode() {
        return this.request.getRequestCode();
    }

    @Nullable
    public Uri getRequestUrl() {
        return this.request.getUrl();
    }

    @Nullable
    public Uri getDeepLinkUrl() {
        return this.deepLinkUrl;
    }

    public String toJson() throws JSONException {
        JSONObject result = new JSONObject();
        result.put(KEY_STATUS, this.status);
        result.put(KEY_DEEP_LINK_URL, (Object)this.deepLinkUrl.toString());
        result.put(KEY_BROWSER_SWITCH_REQUEST, (Object)this.request.toJson());
        return result.toString();
    }
}

