/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxItem;
import com.box.sdk.BoxResourceIterable;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.util.ArrayList;
import java.util.List;

public class Metadata {
    public static final String DEFAULT_METADATA_TYPE = "properties";
    public static final String GLOBAL_METADATA_SCOPE = "global";
    public static final String ENTERPRISE_METADATA_SCOPE = "enterprise";
    public static final int DEFAULT_LIMIT = 100;
    private static final URLTemplate GET_ALL_METADATA_URL_TEMPLATE = new URLTemplate("/metadata");
    private final JsonObject values;
    private JsonArray operations;

    public Metadata() {
        this.values = new JsonObject();
    }

    Metadata(JsonObject values) {
        this.values = values;
    }

    public Metadata(Metadata other) {
        this.values = new JsonObject(other.values);
    }

    public static Iterable<Metadata> getAllMetadata(BoxItem item, String ... fields) {
        QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new BoxResourceIterable<Metadata>(item.getAPI(), GET_ALL_METADATA_URL_TEMPLATE.buildWithQuery(item.getItemURL().toString(), builder.toString(), new Object[0]), 100){

            @Override
            protected Metadata factory(JsonObject jsonObject) {
                return new Metadata(jsonObject);
            }
        };
    }

    public String getID() {
        return this.get("/$id");
    }

    public String getTypeName() {
        return this.get("/$type");
    }

    public String getParentID() {
        return this.get("/$parent");
    }

    public String getScope() {
        return this.get("/$scope");
    }

    public String getTemplateName() {
        return this.get("/$template");
    }

    public Metadata add(String path, String value) {
        this.values.add(this.pathToProperty(path), value);
        this.addOp("add", path, value);
        return this;
    }

    public Metadata replace(String path, String value) {
        this.values.set(this.pathToProperty(path), value);
        this.addOp("replace", path, value);
        return this;
    }

    public Metadata remove(String path) {
        this.values.remove(this.pathToProperty(path));
        this.addOp("remove", path, null);
        return this;
    }

    public Metadata test(String path, String value) {
        this.addOp("test", path, value);
        return this;
    }

    public String get(String path) {
        JsonValue value = this.values.get(this.pathToProperty(path));
        if (value == null) {
            return null;
        }
        if (value.isNumber()) {
            return value.toString();
        }
        return value.asString();
    }

    public List<String> getPropertyPaths() {
        ArrayList<String> result = new ArrayList<String>();
        for (String property : this.values.names()) {
            if (property.startsWith("$")) continue;
            result.add(this.propertyToPath(property));
        }
        return result;
    }

    public String getPatch() {
        if (this.operations == null) {
            return "[]";
        }
        return this.operations.toString();
    }

    public String toString() {
        return this.values.toString();
    }

    private String pathToProperty(String path) {
        if (path == null || !path.startsWith("/")) {
            throw new IllegalArgumentException("Path must be prefixed with a \"/\".");
        }
        return path.substring(1);
    }

    private String propertyToPath(String property) {
        if (property == null) {
            throw new IllegalArgumentException("Property must not be null.");
        }
        return "/" + property;
    }

    private void addOp(String op, String path, String value) {
        if (this.operations == null) {
            this.operations = new JsonArray();
        }
        this.operations.add((JsonValue)new JsonObject().add("op", op).add("path", path).add("value", value));
    }

    static String scopeBasedOnType(String typeName) {
        String scope = typeName.equals(DEFAULT_METADATA_TYPE) ? GLOBAL_METADATA_SCOPE : ENTERPRISE_METADATA_SCOPE;
        return scope;
    }
}

