/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdk;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIRequest;
import com.box.sdk.BoxAPIResponse;
import com.box.sdk.BoxCollaborator;
import com.box.sdk.BoxEnterprise;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxGroupMembership;
import com.box.sdk.BoxGroupMembershipIterator;
import com.box.sdk.BoxJSONRequest;
import com.box.sdk.BoxJSONResponse;
import com.box.sdk.BoxResourceType;
import com.box.sdk.BoxUserIterator;
import com.box.sdk.CreateUserParams;
import com.box.sdk.EmailAlias;
import com.box.sdk.QueryStringBuilder;
import com.box.sdk.URLTemplate;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@BoxResourceType(value="user")
public class BoxUser
extends BoxCollaborator {
    public static final String[] ALL_FIELDS = new String[]{"type", "id", "name", "login", "created_at", "modified_at", "role", "language", "timezone", "space_amount", "space_used", "max_upload_size", "tracking_codes", "can_see_managed_users", "is_sync_enabled", "is_external_collab_restricted", "status", "job_title", "phone", "address", "avatar_url", "is_exempt_from_device_limits", "is_exempt_from_login_verification", "enterprise", "my_tags", "hostname", "is_platform_access_only", "external_app_user_id"};
    public static final URLTemplate USER_URL_TEMPLATE = new URLTemplate("users/%s");
    public static final URLTemplate GET_ME_URL = new URLTemplate("users/me");
    public static final URLTemplate USERS_URL_TEMPLATE = new URLTemplate("users");
    public static final URLTemplate USER_MEMBERSHIPS_URL_TEMPLATE = new URLTemplate("users/%s/memberships");
    public static final URLTemplate EMAIL_ALIAS_URL_TEMPLATE = new URLTemplate("users/%s/email_aliases/%s");
    public static final URLTemplate EMAIL_ALIASES_URL_TEMPLATE = new URLTemplate("users/%s/email_aliases");
    public static final URLTemplate MOVE_FOLDER_TO_USER_TEMPLATE = new URLTemplate("users/%s/folders/%s");

    public BoxUser(BoxAPIConnection api, String id) {
        super(api, id);
    }

    public static Info createAppUser(BoxAPIConnection api, String name) {
        return BoxUser.createAppUser(api, name, new CreateUserParams());
    }

    public static Info createAppUser(BoxAPIConnection api, String name, CreateUserParams params) {
        params.setIsPlatformAccessOnly(true);
        return BoxUser.createEnterpriseUser(api, null, name, params);
    }

    public static Info createEnterpriseUser(BoxAPIConnection api, String login, String name) {
        return BoxUser.createEnterpriseUser(api, login, name, null);
    }

    public static Info createEnterpriseUser(BoxAPIConnection api, String login, String name, CreateUserParams params) {
        BoxUser createdUser;
        JsonObject requestJSON = new JsonObject();
        requestJSON.add("login", login);
        requestJSON.add("name", name);
        if (params != null) {
            if (params.getRole() != null) {
                requestJSON.add("role", params.getRole().toJSONValue());
            }
            if (params.getStatus() != null) {
                requestJSON.add("status", params.getStatus().toJSONValue());
            }
            requestJSON.add("language", params.getLanguage());
            requestJSON.add("is_sync_enabled", params.getIsSyncEnabled());
            requestJSON.add("job_title", params.getJobTitle());
            requestJSON.add("phone", params.getPhone());
            requestJSON.add("address", params.getAddress());
            requestJSON.add("space_amount", params.getSpaceAmount());
            requestJSON.add("can_see_managed_users", params.getCanSeeManagedUsers());
            requestJSON.add("timezone", params.getTimezone());
            requestJSON.add("is_exempt_from_device_limits", params.getIsExemptFromDeviceLimits());
            requestJSON.add("is_exempt_from_login_verification", params.getIsExemptFromLoginVerification());
            requestJSON.add("is_platform_access_only", params.getIsPlatformAccessOnly());
            requestJSON.add("external_app_user_id", params.getExternalAppUserId());
        }
        URL url = USERS_URL_TEMPLATE.build(api.getBaseURL(), new Object[0]);
        BoxJSONRequest request = new BoxJSONRequest(api, url, "POST");
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxUser boxUser = createdUser = new BoxUser(api, responseJSON.get("id").asString());
        boxUser.getClass();
        return boxUser.new Info(responseJSON);
    }

    public static BoxUser getCurrentUser(BoxAPIConnection api) {
        URL url = GET_ME_URL.build(api.getBaseURL(), new Object[0]);
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        return new BoxUser(api, jsonObject.get("id").asString());
    }

    public static Iterable<Info> getAllEnterpriseUsers(BoxAPIConnection api) {
        return BoxUser.getAllEnterpriseUsers(api, null, new String[0]);
    }

    public static Iterable<Info> getAllEnterpriseUsers(BoxAPIConnection api, String filterTerm, String ... fields) {
        return BoxUser.getUsersInfoForType(api, filterTerm, null, null, fields);
    }

    public static Iterable<Info> getExternalUsers(BoxAPIConnection api, String filterTerm, String ... fields) {
        return BoxUser.getUsersInfoForType(api, filterTerm, "external", null, fields);
    }

    public static Iterable<Info> getAllEnterpriseOrExternalUsers(BoxAPIConnection api, String filterTerm, String ... fields) {
        return BoxUser.getUsersInfoForType(api, filterTerm, "all", null, fields);
    }

    public static Iterable<Info> getAppUsersByExternalAppUserID(BoxAPIConnection api, String externalAppUserId, String ... fields) {
        return BoxUser.getUsersInfoForType(api, null, null, externalAppUserId, fields);
    }

    private static Iterable<Info> getUsersInfoForType(final BoxAPIConnection api, final String filterTerm, final String userType, final String externalAppUserId, final String ... fields) {
        return new Iterable<Info>(){

            @Override
            public Iterator<Info> iterator() {
                QueryStringBuilder builder = new QueryStringBuilder();
                if (filterTerm != null) {
                    builder.appendParam("filter_term", filterTerm);
                }
                if (userType != null) {
                    builder.appendParam("user_type", userType);
                }
                if (externalAppUserId != null) {
                    builder.appendParam("external_app_user_id", externalAppUserId);
                }
                if (fields.length > 0) {
                    builder.appendParam("fields", fields);
                }
                URL url = USERS_URL_TEMPLATE.buildWithQuery(api.getBaseURL(), builder.toString(), new Object[0]);
                return new BoxUserIterator(api, url);
            }
        };
    }

    public Info getInfo(String ... fields) {
        URL url;
        if (fields.length > 0) {
            String queryString = new QueryStringBuilder().appendParam("fields", fields).toString();
            url = USER_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        } else {
            url = USER_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        }
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        return new Info(jsonObject);
    }

    public Collection<BoxGroupMembership.Info> getMemberships() {
        BoxAPIConnection api = this.getAPI();
        URL url = USER_MEMBERSHIPS_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(api, url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        int entriesCount = responseJSON.get("total_count").asInt();
        ArrayList<BoxGroupMembership.Info> memberships = new ArrayList<BoxGroupMembership.Info>(entriesCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue entry : entries) {
            BoxGroupMembership membership;
            JsonObject entryObject = entry.asObject();
            BoxGroupMembership boxGroupMembership = membership = new BoxGroupMembership(api, entryObject.get("id").asString());
            boxGroupMembership.getClass();
            BoxGroupMembership.Info info = boxGroupMembership.new BoxGroupMembership.Info(entryObject);
            memberships.add(info);
        }
        return memberships;
    }

    public Iterable<BoxGroupMembership.Info> getAllMemberships(String ... fields) {
        final QueryStringBuilder builder = new QueryStringBuilder();
        if (fields.length > 0) {
            builder.appendParam("fields", fields);
        }
        return new Iterable<BoxGroupMembership.Info>(){

            @Override
            public Iterator<BoxGroupMembership.Info> iterator() {
                URL url = USER_MEMBERSHIPS_URL_TEMPLATE.buildWithQuery(BoxUser.this.getAPI().getBaseURL(), builder.toString(), BoxUser.this.getID());
                return new BoxGroupMembershipIterator(BoxUser.this.getAPI(), url);
            }
        };
    }

    public EmailAlias addEmailAlias(String email) {
        return this.addEmailAlias(email, false);
    }

    public EmailAlias addEmailAlias(String email, boolean isConfirmed) {
        URL url = EMAIL_ALIASES_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "POST");
        JsonObject requestJSON = new JsonObject().add("email", email);
        if (isConfirmed) {
            requestJSON.add("is_confirmed", isConfirmed);
        }
        request.setBody(requestJSON.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        return new EmailAlias(responseJSON);
    }

    public void deleteEmailAlias(String emailAliasID) {
        URL url = EMAIL_ALIAS_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID(), emailAliasID);
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public Collection<EmailAlias> getEmailAliases() {
        URL url = EMAIL_ALIASES_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "GET");
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        int totalCount = responseJSON.get("total_count").asInt();
        ArrayList<EmailAlias> emailAliases = new ArrayList<EmailAlias>(totalCount);
        JsonArray entries = responseJSON.get("entries").asArray();
        for (JsonValue value : entries) {
            JsonObject emailAliasJSON = value.asObject();
            emailAliases.add(new EmailAlias(emailAliasJSON));
        }
        return emailAliases;
    }

    public void delete(boolean notifyUser, boolean force) {
        String queryString = new QueryStringBuilder().appendParam("notify", String.valueOf(notifyUser)).appendParam("force", String.valueOf(force)).toString();
        URL url = USER_URL_TEMPLATE.buildWithQuery(this.getAPI().getBaseURL(), queryString, this.getID());
        BoxAPIRequest request = new BoxAPIRequest(this.getAPI(), url, "DELETE");
        BoxAPIResponse response = request.send();
        response.disconnect();
    }

    public void updateInfo(Info info) {
        URL url = USER_URL_TEMPLATE.build(this.getAPI().getBaseURL(), this.getID());
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        request.setBody(info.getPendingChanges());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject jsonObject = JsonObject.readFrom((String)response.getJSON());
        info.update(jsonObject);
    }

    public BoxFolder.Info moveFolderToUser(String sourceUserID) {
        BoxFolder movedFolder;
        URL url = MOVE_FOLDER_TO_USER_TEMPLATE.build(this.getAPI().getBaseURL(), sourceUserID, "0");
        BoxJSONRequest request = new BoxJSONRequest(this.getAPI(), url, "PUT");
        JsonObject idValue = new JsonObject();
        idValue.add("id", this.getID());
        JsonObject ownedBy = new JsonObject();
        ownedBy.add("owned_by", (JsonValue)idValue);
        request.setBody(ownedBy.toString());
        BoxJSONResponse response = (BoxJSONResponse)request.send();
        JsonObject responseJSON = JsonObject.readFrom((String)response.getJSON());
        BoxFolder boxFolder = movedFolder = new BoxFolder(this.getAPI(), responseJSON.get("id").asString());
        boxFolder.getClass();
        return boxFolder.new BoxFolder.Info(responseJSON);
    }

    public class Info
    extends BoxCollaborator.Info {
        private String login;
        private Role role;
        private String language;
        private String timezone;
        private long spaceAmount;
        private long spaceUsed;
        private long maxUploadSize;
        private boolean canSeeManagedUsers;
        private boolean isSyncEnabled;
        private boolean isExternalCollabRestricted;
        private Status status;
        private String jobTitle;
        private String phone;
        private String address;
        private String avatarURL;
        private boolean isExemptFromDeviceLimits;
        private boolean isExemptFromLoginVerification;
        private boolean isPasswordResetRequired;
        private boolean isPlatformAccessOnly;
        private String externalAppUserId;
        private BoxEnterprise enterprise;
        private List<String> myTags;
        private String hostname;
        private Map<String, String> trackingCodes;

        public Info() {
        }

        Info(JsonObject jsonObject) {
            super(jsonObject);
        }

        @Override
        public BoxUser getResource() {
            return BoxUser.this;
        }

        public String getLogin() {
            return this.login;
        }

        public void setLogin(String login) {
            this.login = login;
            this.addPendingChange("login", login);
        }

        public Role getRole() {
            return this.role;
        }

        public void setRole(Role role) {
            this.role = role;
            this.addPendingChange("role", role.name().toLowerCase());
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
            this.addPendingChange("language", language);
        }

        public String getTimezone() {
            return this.timezone;
        }

        public void setTimezone(String timezone) {
            this.timezone = timezone;
            this.addPendingChange("timezone", timezone);
        }

        public long getSpaceAmount() {
            return this.spaceAmount;
        }

        public void setSpaceAmount(long spaceAmount) {
            this.spaceAmount = spaceAmount;
            this.addPendingChange("space_amount", spaceAmount);
        }

        public long getSpaceUsed() {
            return this.spaceUsed;
        }

        public long getMaxUploadSize() {
            return this.maxUploadSize;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setStatus(Status status) {
            this.status = status;
            this.addPendingChange("status", status.name().toLowerCase());
        }

        public String getJobTitle() {
            return this.jobTitle;
        }

        public void setJobTitle(String jobTitle) {
            this.jobTitle = jobTitle;
            this.addPendingChange("job_title", jobTitle);
        }

        public String getPhone() {
            return this.phone;
        }

        public void setPhone(String phone) {
            this.phone = phone;
            this.addPendingChange("phone", phone);
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
            this.addPendingChange("address", address);
        }

        public String getAvatarURL() {
            return this.avatarURL;
        }

        public BoxEnterprise getEnterprise() {
            return this.enterprise;
        }

        public void removeEnterprise() {
            this.removeChildObject("enterprise");
            this.enterprise = null;
            this.addChildObject("enterprise", null);
        }

        public boolean getIsSyncEnabled() {
            return this.isSyncEnabled;
        }

        public boolean getIsExternalCollabRestricted() {
            return this.isExternalCollabRestricted;
        }

        public void setIsSyncEnabled(boolean enabled) {
            this.isSyncEnabled = enabled;
            this.addPendingChange("is_sync_enabled", enabled);
        }

        public boolean getCanSeeManagedUsers() {
            return this.canSeeManagedUsers;
        }

        public void setCanSeeManagedUsers(boolean canSeeManagedUsers) {
            this.canSeeManagedUsers = canSeeManagedUsers;
            this.addPendingChange("can_see_managed_users", canSeeManagedUsers);
        }

        public boolean getIsExemptFromDeviceLimits() {
            return this.isExemptFromDeviceLimits;
        }

        public void setIsExemptFromDeviceLimits(boolean isExemptFromDeviceLimits) {
            this.isExemptFromDeviceLimits = isExemptFromDeviceLimits;
            this.addPendingChange("is_exempt_from_device_limits", isExemptFromDeviceLimits);
        }

        public boolean getIsExemptFromLoginVerification() {
            return this.isExemptFromLoginVerification;
        }

        public void setIsExemptFromLoginVerification(boolean isExemptFromLoginVerification) {
            this.isExemptFromLoginVerification = isExemptFromLoginVerification;
            this.addPendingChange("is_exempt_from_login_verification", isExemptFromLoginVerification);
        }

        public boolean getIsPasswordResetRequired() {
            return this.isPasswordResetRequired;
        }

        public void setIsPasswordResetRequired(boolean isPasswordResetRequired) {
            this.isPasswordResetRequired = isPasswordResetRequired;
            this.addPendingChange("is_password_reset_required", isPasswordResetRequired);
        }

        public boolean getIsPlatformAccessOnly() {
            return this.isPlatformAccessOnly;
        }

        public String getExternalAppUserId() {
            return this.externalAppUserId;
        }

        public void setExternalAppUserId(String externalAppUserId) {
            this.externalAppUserId = externalAppUserId;
            this.addPendingChange("external_app_user_id", externalAppUserId);
        }

        public List<String> getMyTags() {
            return this.myTags;
        }

        public String getHostname() {
            return this.hostname;
        }

        public Map<String, String> getTrackingCodes() {
            return this.trackingCodes;
        }

        @Override
        protected void parseJSONMember(JsonObject.Member member) {
            super.parseJSONMember(member);
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if (memberName.equals("login")) {
                this.login = value.asString();
            } else if (memberName.equals("role")) {
                this.role = Role.fromJSONValue(value.asString());
            } else if (memberName.equals("language")) {
                this.language = value.asString();
            } else if (memberName.equals("timezone")) {
                this.timezone = value.asString();
            } else if (memberName.equals("space_amount")) {
                this.spaceAmount = Double.valueOf(value.toString()).longValue();
            } else if (memberName.equals("space_used")) {
                this.spaceUsed = Double.valueOf(value.toString()).longValue();
            } else if (memberName.equals("max_upload_size")) {
                this.maxUploadSize = Double.valueOf(value.toString()).longValue();
            } else if (memberName.equals("status")) {
                this.status = Status.fromJSONValue(value.asString());
            } else if (memberName.equals("job_title")) {
                this.jobTitle = value.asString();
            } else if (memberName.equals("phone")) {
                this.phone = value.asString();
            } else if (memberName.equals("address")) {
                this.address = value.asString();
            } else if (memberName.equals("avatar_url")) {
                this.avatarURL = value.asString();
            } else if (memberName.equals("can_see_managed_users")) {
                this.canSeeManagedUsers = value.asBoolean();
            } else if (memberName.equals("is_sync_enabled")) {
                this.isSyncEnabled = value.asBoolean();
            } else if (memberName.equals("is_external_collab_restricted")) {
                this.isExternalCollabRestricted = value.asBoolean();
            } else if (memberName.equals("is_exempt_from_device_limits")) {
                this.isExemptFromDeviceLimits = value.asBoolean();
            } else if (memberName.equals("is_exempt_from_login_verification")) {
                this.isExemptFromLoginVerification = value.asBoolean();
            } else if (memberName.equals("is_password_reset_required")) {
                this.isPasswordResetRequired = value.asBoolean();
            } else if (memberName.equals("is_platform_access_only")) {
                this.isPlatformAccessOnly = value.asBoolean();
            } else if (memberName.equals("external_app_user_id")) {
                this.externalAppUserId = value.asString();
            } else if (memberName.equals("enterprise")) {
                JsonObject jsonObject = value.asObject();
                if (this.enterprise == null) {
                    this.enterprise = new BoxEnterprise(jsonObject);
                } else {
                    this.enterprise.update(jsonObject);
                }
            } else if (memberName.equals("my_tags")) {
                this.myTags = this.parseMyTags(value.asArray());
            } else if (memberName.equals("hostname")) {
                this.hostname = value.asString();
            } else if (memberName.equals("tracking_codes")) {
                this.trackingCodes = this.parseTrackingCodes(value.asArray());
            }
        }

        private List<String> parseMyTags(JsonArray jsonArray) {
            ArrayList<String> myTags = new ArrayList<String>(jsonArray.size());
            for (JsonValue value : jsonArray) {
                myTags.add(value.asString());
            }
            return myTags;
        }

        private Map<String, String> parseTrackingCodes(JsonArray jsonArray) {
            HashMap<String, String> result = new HashMap<String, String>();
            if (jsonArray == null) {
                return null;
            }
            List valuesList = jsonArray.values();
            for (JsonValue jsonValue : valuesList) {
                JsonObject object = jsonValue.asObject();
                result.put(object.get("name").asString().toString(), object.get("value").asString().toString());
            }
            return result;
        }
    }

    public static enum Status {
        ACTIVE("active"),
        INACTIVE("inactive"),
        CANNOT_DELETE_EDIT("cannot_delete_edit"),
        CANNOT_DELETE_EDIT_UPLOAD("cannot_delete_edit_upload");

        private final String jsonValue;

        private Status(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Status fromJSONValue(String jsonValue) {
            return Status.valueOf(jsonValue.toUpperCase());
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }

    public static enum Role {
        ADMIN("admin"),
        COADMIN("coadmin"),
        USER("user");

        private final String jsonValue;

        private Role(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        static Role fromJSONValue(String jsonValue) {
            return Role.valueOf(jsonValue.toUpperCase());
        }

        String toJSONValue() {
            return this.jsonValue;
        }
    }
}

