/*
 * Decompiled with CFR 0.152.
 */
package com.box.sdkgen.managers.authorization;

import com.box.sdkgen.internal.utils.Entry;
import com.box.sdkgen.internal.utils.UtilsManager;
import com.box.sdkgen.managers.authorization.AuthorizeUserHeaders;
import com.box.sdkgen.managers.authorization.AuthorizeUserQueryParams;
import com.box.sdkgen.managers.authorization.RefreshAccessTokenHeaders;
import com.box.sdkgen.managers.authorization.RequestAccessTokenHeaders;
import com.box.sdkgen.managers.authorization.RevokeAccessTokenHeaders;
import com.box.sdkgen.networking.auth.Authentication;
import com.box.sdkgen.networking.fetchoptions.FetchOptions;
import com.box.sdkgen.networking.fetchoptions.ResponseFormat;
import com.box.sdkgen.networking.fetchresponse.FetchResponse;
import com.box.sdkgen.networking.network.NetworkSession;
import com.box.sdkgen.schemas.accesstoken.AccessToken;
import com.box.sdkgen.schemas.postoauth2revoke.PostOAuth2Revoke;
import com.box.sdkgen.schemas.postoauth2token.PostOAuth2Token;
import com.box.sdkgen.schemas.postoauth2tokenrefreshaccesstoken.PostOAuth2TokenRefreshAccessToken;
import com.box.sdkgen.serialization.json.JsonManager;
import java.util.Map;

public class AuthorizationManager {
    public Authentication auth;
    public NetworkSession networkSession;

    public AuthorizationManager() {
        this.networkSession = new NetworkSession();
    }

    protected AuthorizationManager(Builder builder) {
        this.auth = builder.auth;
        this.networkSession = builder.networkSession;
    }

    public void authorizeUser(AuthorizeUserQueryParams queryParams) {
        this.authorizeUser(queryParams, new AuthorizeUserHeaders());
    }

    public void authorizeUser(AuthorizeUserQueryParams queryParams, AuthorizeUserHeaders headers) {
        Map<String, String> queryParamsMap = UtilsManager.prepareParams(UtilsManager.mapOf(UtilsManager.entryOf("response_type", UtilsManager.convertToString(queryParams.getResponseType())), UtilsManager.entryOf("client_id", UtilsManager.convertToString(queryParams.getClientId())), UtilsManager.entryOf("redirect_uri", UtilsManager.convertToString(queryParams.getRedirectUri())), UtilsManager.entryOf("state", UtilsManager.convertToString(queryParams.getState())), UtilsManager.entryOf("scope", UtilsManager.convertToString(queryParams.getScope()))));
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getOauth2Url(), "/authorize"), "GET").params(queryParamsMap).headers(headersMap).responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public AccessToken requestAccessToken(PostOAuth2Token requestBody) {
        return this.requestAccessToken(requestBody, new RequestAccessTokenHeaders());
    }

    public AccessToken requestAccessToken(PostOAuth2Token requestBody, RequestAccessTokenHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/oauth2/token"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/x-www-form-urlencoded").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AccessToken.class);
    }

    public AccessToken refreshAccessToken(PostOAuth2TokenRefreshAccessToken requestBody) {
        return this.refreshAccessToken(requestBody, new RefreshAccessTokenHeaders());
    }

    public AccessToken refreshAccessToken(PostOAuth2TokenRefreshAccessToken requestBody, RefreshAccessTokenHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/oauth2/token#refresh"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/x-www-form-urlencoded").responseFormat(ResponseFormat.JSON).auth(this.auth).networkSession(this.networkSession).build());
        return JsonManager.deserialize(response.getData(), AccessToken.class);
    }

    public void revokeAccessToken(PostOAuth2Revoke requestBody) {
        this.revokeAccessToken(requestBody, new RevokeAccessTokenHeaders());
    }

    public void revokeAccessToken(PostOAuth2Revoke requestBody, RevokeAccessTokenHeaders headers) {
        Map<String, String> headersMap = UtilsManager.prepareParams(UtilsManager.mergeMaps(UtilsManager.mapOf(new Entry[0]), headers.getExtraHeaders()));
        FetchResponse response = this.networkSession.getNetworkClient().fetch(new FetchOptions.Builder(String.join((CharSequence)"", this.networkSession.getBaseUrls().getBaseUrl(), "/oauth2/revoke"), "POST").headers(headersMap).data(JsonManager.serialize(requestBody)).contentType("application/x-www-form-urlencoded").responseFormat(ResponseFormat.NO_CONTENT).auth(this.auth).networkSession(this.networkSession).build());
    }

    public Authentication getAuth() {
        return this.auth;
    }

    public NetworkSession getNetworkSession() {
        return this.networkSession;
    }

    public static class Builder {
        protected Authentication auth;
        protected NetworkSession networkSession = new NetworkSession();

        public Builder auth(Authentication auth) {
            this.auth = auth;
            return this;
        }

        public Builder networkSession(NetworkSession networkSession) {
            this.networkSession = networkSession;
            return this;
        }

        public AuthorizationManager build() {
            return new AuthorizationManager(this);
        }
    }
}

