package com.box.sdkgen.managers.search;

import static com.box.sdkgen.internal.utils.UtilsManager.mapOf;

import java.util.Map;

public class SearchByMetadataQueryHeaders {

  public Map<String, String> extraHeaders;

  public SearchByMetadataQueryHeaders() {
    this.extraHeaders = mapOf();
  }

  protected SearchByMetadataQueryHeaders(Builder builder) {
    this.extraHeaders = builder.extraHeaders;
  }

  public Map<String, String> getExtraHeaders() {
    return extraHeaders;
  }

  public static class Builder {

    protected Map<String, String> extraHeaders;

    public Builder() {
      this.extraHeaders = mapOf();
    }

    public Builder extraHeaders(Map<String, String> extraHeaders) {
      this.extraHeaders = extraHeaders;
      return this;
    }

    public SearchByMetadataQueryHeaders build() {
      return new SearchByMetadataQueryHeaders(this);
    }
  }
}
