/*
 * Decompiled with CFR 0.152.
 */
package com.bottlerocketstudios.barcode.generation.ui;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.bottlerocketstudios.barcode.R;
import com.bottlerocketstudios.barcode.generation.controller.AsyncBarcodeBitmapGenerator;
import com.bottlerocketstudios.barcode.generation.model.BarcodeFormatCrossReference;
import com.bottlerocketstudios.barcode.generation.model.BarcodeRequest;
import com.google.zxing.BarcodeFormat;

public class BarcodeView
extends ImageView {
    private static final BarcodeFormatCrossReference DEFAULT_BARCODE_FORMAT_STYLEABLE_VALUE = BarcodeFormatCrossReference.QR_CODE;
    BarcodeFormat mBarcodeFormat = BarcodeFormat.QR_CODE;
    private String mBarcodeText;
    private int mDrawableWidth;
    private int mDrawableHeight;
    private int mBarcodeForegroundColor = -16777216;
    private int mBarcodeBackgroundColor = -1;
    private String mBarcodeCharacterSet = "ISO-8859-1";
    private AsyncBarcodeBitmapGenerator mAsyncBarcodeBitmapGenerator = new AsyncBarcodeBitmapGenerator(true);
    private UpdateRunnable mUpdateRunnable = new UpdateRunnable(this);
    private AsyncBarcodeBitmapGenerator.BarcodeGenerationListener mBarcodeGenerationListener = new AsyncBarcodeBitmapGenerator.BarcodeGenerationListener(){

        @Override
        public void onGenerationComplete(Bitmap bitmap) {
            BarcodeView.this.displayNewBarcode(bitmap);
        }
    };

    public BarcodeView(Context context) {
        super(context);
        this.init(null, 0, 0);
    }

    public BarcodeView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0, 0);
    }

    public BarcodeView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr, 0);
    }

    @TargetApi(value=21)
    public BarcodeView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs, defStyleAttr, defStyleRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        BarcodeFormatCrossReference barcodeFormatCrossReference = DEFAULT_BARCODE_FORMAT_STYLEABLE_VALUE;
        if (attrs != null) {
            TypedArray styledAttributes = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.BarcodeView, defStyleAttr, defStyleRes);
            try {
                barcodeFormatCrossReference = this.isInEditMode() ? BarcodeFormatCrossReference.lookupByStyleableEnumString(styledAttributes.getString(R.styleable.BarcodeView_barcode_format)) : BarcodeFormatCrossReference.lookupByStyleableEnumInt(styledAttributes.getInt(R.styleable.BarcodeView_barcode_format, 0));
                this.mBarcodeForegroundColor = styledAttributes.getColor(R.styleable.BarcodeView_barcode_foreground_color, this.mBarcodeForegroundColor);
                this.mBarcodeBackgroundColor = styledAttributes.getColor(R.styleable.BarcodeView_barcode_background_color, this.mBarcodeBackgroundColor);
                this.mBarcodeText = styledAttributes.getString(R.styleable.BarcodeView_barcode_text);
                String characterSet = styledAttributes.getString(R.styleable.BarcodeView_barcode_character_set);
                if (!TextUtils.isEmpty((CharSequence)characterSet)) {
                    this.mBarcodeCharacterSet = characterSet;
                }
            }
            finally {
                styledAttributes.recycle();
            }
        }
        this.mBarcodeFormat = barcodeFormatCrossReference.getBarcodeFormat();
    }

    public void setBarcodeText(String barcodeText) {
        if (!TextUtils.equals((CharSequence)this.mBarcodeText, (CharSequence)barcodeText)) {
            this.mBarcodeText = barcodeText;
            this.postUpdateBarcode();
        }
    }

    public void setBarcodeForegroundColor(int foregroundColor) {
        if (foregroundColor != this.mBarcodeForegroundColor) {
            this.mBarcodeForegroundColor = foregroundColor;
            this.postUpdateBarcode();
        }
    }

    public void setBarcodeBackgroundColor(int backgroundColor) {
        if (backgroundColor != this.mBarcodeBackgroundColor) {
            this.mBarcodeBackgroundColor = backgroundColor;
            this.postUpdateBarcode();
        }
    }

    public void setBarcodeFormat(BarcodeFormat barcodeFormat) {
        if (!this.mBarcodeFormat.equals((Object)barcodeFormat)) {
            this.mBarcodeFormat = barcodeFormat;
            this.postUpdateBarcode();
        }
    }

    public void setBarcodeCharacterSet(String characterSet) {
        if (!TextUtils.equals((CharSequence)this.mBarcodeCharacterSet, (CharSequence)characterSet)) {
            this.mBarcodeCharacterSet = characterSet;
            this.postUpdateBarcode();
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        int width = w - (this.getPaddingLeft() + this.getPaddingRight());
        int height = h - (this.getPaddingTop() + this.getPaddingBottom());
        if (this.mDrawableWidth != width || this.mDrawableHeight != height) {
            this.mDrawableWidth = width;
            this.mDrawableHeight = height;
            this.postUpdateBarcode();
        }
    }

    public void postUpdateBarcode() {
        this.removeCallbacks(this.mUpdateRunnable);
        this.post(this.mUpdateRunnable);
    }

    private void updateBarcode() {
        if (this.mDrawableHeight > 0 && this.mDrawableWidth > 0 && !TextUtils.isEmpty((CharSequence)this.mBarcodeText)) {
            BarcodeRequest barcodeRequest = new BarcodeRequest.BarcodeRequestBuilder().barcodeText(this.mBarcodeText).barcodeFormat(this.mBarcodeFormat).width(this.mDrawableWidth).height(this.mDrawableHeight).foregroundColor(this.mBarcodeForegroundColor).backgroundColor(this.mBarcodeBackgroundColor).characterSet(this.mBarcodeCharacterSet).build();
            this.mAsyncBarcodeBitmapGenerator.startGeneration(barcodeRequest, this.mBarcodeGenerationListener);
        }
    }

    private void displayNewBarcode(Bitmap bitmap) {
        this.setImageBitmap(bitmap);
    }

    private static class UpdateRunnable
    implements Runnable {
        private BarcodeView mBarcodeView;

        public UpdateRunnable(BarcodeView barcodeView) {
            this.mBarcodeView = barcodeView;
        }

        @Override
        public void run() {
            this.mBarcodeView.updateBarcode();
        }
    }
}

