/*
 * Decompiled with CFR 0.152.
 */
package com.bottlerocketstudios.barcode.generation.model;

import android.text.TextUtils;
import com.google.zxing.BarcodeFormat;

public class BarcodeRequest {
    public static final String DEFAULT_CHARACTERSET = "ISO-8859-1";
    public static final int DEFAULT_FOREGROUND_COLOR = -16777216;
    public static final int DEFAULT_BACKGROUND_COLOR = -1;
    public static final BarcodeFormat DEFAULT_BARCODE_FORMAT = BarcodeFormat.QR_CODE;
    private final String mBarcodeText;
    private final BarcodeFormat mBarcodeFormat;
    private final int mWidth;
    private final int mHeight;
    private final String mCharacterSet;
    private final int mForegroundColor;
    private final int mBackgroundColor;

    private BarcodeRequest(String barcodeText, BarcodeFormat barcodeFormat, int width, int height, String characterSet, int foregroundColor, int backgroundColor) {
        this.mBarcodeText = barcodeText;
        this.mBarcodeFormat = barcodeFormat;
        this.mWidth = width;
        this.mHeight = height;
        this.mCharacterSet = characterSet;
        this.mForegroundColor = foregroundColor;
        this.mBackgroundColor = backgroundColor;
    }

    public String getBarcodeText() {
        return this.mBarcodeText;
    }

    public BarcodeFormat getBarcodeFormat() {
        return this.mBarcodeFormat;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public String getCharacterSet() {
        return this.mCharacterSet;
    }

    public int getForegroundColor() {
        return this.mForegroundColor;
    }

    public int getBackgroundColor() {
        return this.mBackgroundColor;
    }

    public static class BarcodeRequestBuilder {
        private String mBarcodeText;
        private BarcodeFormat mBarcodeFormat;
        private int mWidth;
        private int mHeight;
        private String mCharacterSet;
        private Integer mForegroundColor;
        private Integer mBackgroundColor;

        public BarcodeRequestBuilder barcodeText(String text) {
            this.mBarcodeText = text;
            return this;
        }

        public BarcodeRequestBuilder barcodeFormat(BarcodeFormat format) {
            this.mBarcodeFormat = format;
            return this;
        }

        public BarcodeRequestBuilder width(int width) {
            this.mWidth = width;
            return this;
        }

        public BarcodeRequestBuilder height(int height) {
            this.mHeight = height;
            return this;
        }

        public BarcodeRequestBuilder characterSet(String characterSet) {
            this.mCharacterSet = characterSet;
            return this;
        }

        public BarcodeRequestBuilder foregroundColor(int foregroundColor) {
            this.mForegroundColor = foregroundColor;
            return this;
        }

        public BarcodeRequestBuilder backgroundColor(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
            return this;
        }

        public BarcodeRequest build() {
            if (TextUtils.isEmpty((CharSequence)this.mBarcodeText)) {
                throw new IllegalArgumentException("Barcode text cannot be empty");
            }
            if (this.mBarcodeFormat == null) {
                this.mBarcodeFormat = DEFAULT_BARCODE_FORMAT;
            }
            if (this.mWidth <= 0 || this.mHeight <= 0) {
                throw new IllegalArgumentException("Width and height must be non-zero positive numbers");
            }
            if (TextUtils.isEmpty((CharSequence)this.mCharacterSet)) {
                this.mCharacterSet = BarcodeRequest.DEFAULT_CHARACTERSET;
            }
            if (this.mForegroundColor == null) {
                this.mForegroundColor = -16777216;
            }
            if (this.mBackgroundColor == null) {
                this.mBackgroundColor = -1;
            }
            return new BarcodeRequest(this.mBarcodeText, this.mBarcodeFormat, this.mWidth, this.mHeight, this.mCharacterSet, this.mForegroundColor, this.mBackgroundColor);
        }
    }
}

