/*
 * Decompiled with CFR 0.152.
 */
package com.bottlerocketstudios.barcode.generation.controller;

import android.graphics.Bitmap;
import android.util.Log;
import com.bottlerocketstudios.barcode.generation.model.BarcodeRequest;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.util.EnumMap;

public class BarcodeBitmapGenerator {
    private static final String TAG = BarcodeBitmapGenerator.class.getSimpleName();

    public Bitmap generate(BarcodeRequest barcodeRequest) {
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        EnumMap<EncodeHintType, String> hints = new EnumMap<EncodeHintType, String>(EncodeHintType.class);
        hints.put(EncodeHintType.CHARACTER_SET, barcodeRequest.getCharacterSet());
        try {
            BitMatrix bitMatrix = multiFormatWriter.encode(barcodeRequest.getBarcodeText(), barcodeRequest.getBarcodeFormat(), barcodeRequest.getWidth(), barcodeRequest.getHeight(), hints);
            return this.convertBitMatrixToBitmap(bitMatrix, barcodeRequest.getForegroundColor(), barcodeRequest.getBackgroundColor());
        }
        catch (WriterException e) {
            Log.e((String)TAG, (String)"Caught com.google.zxing.WriterException", (Throwable)e);
            return null;
        }
    }

    private Bitmap convertBitMatrixToBitmap(BitMatrix bitMatrix, int foregroundColor, int backgroundColor) {
        int width = bitMatrix.getWidth();
        int height = bitMatrix.getHeight();
        int[] pixels = new int[width * height];
        for (int y = 0; y < height; ++y) {
            int offset = y * width;
            for (int x = 0; x < width; ++x) {
                pixels[offset + x] = bitMatrix.get(x, y) ? foregroundColor : backgroundColor;
            }
        }
        return Bitmap.createBitmap((int[])pixels, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }
}

