/*
 * Decompiled with CFR 0.152.
 */
package com.bottlerocketstudios.barcode.generation.controller;

import android.graphics.Bitmap;
import android.os.AsyncTask;
import com.bottlerocketstudios.barcode.generation.controller.BarcodeBitmapGenerator;
import com.bottlerocketstudios.barcode.generation.model.BarcodeRequest;
import java.lang.ref.WeakReference;

public class AsyncBarcodeBitmapGenerator {
    private final boolean mSingleOperation;
    private BarcodeGenerationTask mBarcodeGenerationTask;

    public AsyncBarcodeBitmapGenerator(boolean singleOperation) {
        this.mSingleOperation = singleOperation;
    }

    public void startGeneration(BarcodeRequest barcodeRequest, BarcodeGenerationListener listener) {
        if (this.mBarcodeGenerationTask != null && this.mSingleOperation) {
            this.mBarcodeGenerationTask.cancel(false);
        }
        this.mBarcodeGenerationTask = new BarcodeGenerationTask(listener);
        this.mBarcodeGenerationTask.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new BarcodeRequest[]{barcodeRequest});
    }

    public static interface BarcodeGenerationListener {
        public void onGenerationComplete(Bitmap var1);
    }

    private static class BarcodeGenerationTask
    extends AsyncTask<BarcodeRequest, Void, Bitmap> {
        private final WeakReference<BarcodeGenerationListener> mTaskListenerRef;

        public BarcodeGenerationTask(BarcodeGenerationListener listener) {
            this.mTaskListenerRef = new WeakReference<BarcodeGenerationListener>(listener);
        }

        protected Bitmap doInBackground(BarcodeRequest ... params) {
            return new BarcodeBitmapGenerator().generate(params[0]);
        }

        protected void onPostExecute(Bitmap bitmap) {
            super.onPostExecute((Object)bitmap);
            BarcodeGenerationListener listener = (BarcodeGenerationListener)this.mTaskListenerRef.get();
            if (listener != null) {
                listener.onGenerationComplete(bitmap);
            }
        }
    }
}

