/*
 * Decompiled with CFR 0.152.
 */
package com.bottlerocketstudios.barcode.detection.controller;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.bottlerocketstudios.barcode.detection.camera.CameraManager;
import com.bottlerocketstudios.barcode.detection.controller.DecodeThread;
import com.bottlerocketstudios.barcode.detection.controller.ZXingFacade;
import com.bottlerocketstudios.barcode.detection.model.ZXingConfiguration;
import com.google.zxing.Result;
import com.google.zxing.ResultPointCallback;

public final class ZXingFacadeHandler
extends Handler {
    private static final String TAG = ZXingFacadeHandler.class.getSimpleName();
    private final ZXingFacade mZXingFacade;
    private final DecodeThread decodeThread;
    private final CameraManager mCameraManager;
    private State state;

    ZXingFacadeHandler(ZXingFacade ZXingFacade2, ResultPointCallback resultPointCallback, ZXingConfiguration ZXingConfiguration2) {
        this.mZXingFacade = ZXingFacade2;
        this.decodeThread = new DecodeThread(ZXingFacade2, resultPointCallback, ZXingConfiguration2);
        this.decodeThread.start();
        this.state = State.SUCCESS;
        this.mCameraManager = ZXingFacade2.getCameraManager();
        this.mCameraManager.startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            case 70005: {
                this.restartPreviewAndDecode();
                break;
            }
            case 70003: {
                this.state = State.SUCCESS;
                Bundle bundle = message.getData();
                Bitmap barcode = null;
                float scaleFactor = 1.0f;
                if (bundle != null) {
                    byte[] compressedBitmap = bundle.getByteArray("barcode_bitmap");
                    if (compressedBitmap != null) {
                        barcode = BitmapFactory.decodeByteArray((byte[])compressedBitmap, (int)0, (int)compressedBitmap.length, null);
                        barcode = barcode.copy(Bitmap.Config.ARGB_8888, true);
                    }
                    scaleFactor = bundle.getFloat("barcode_scaled_factor");
                }
                this.mZXingFacade.handleDecode((Result)message.obj, barcode, scaleFactor);
                break;
            }
            case 70004: {
                this.state = State.PREVIEW;
                this.mZXingFacade.getCameraManager().requestPreviewFrame(this.decodeThread.getHandler(), 70001);
            }
        }
    }

    public void quitSynchronously() {
        this.state = State.DONE;
        this.mZXingFacade.getCameraManager().stopPreview();
        Message quit = Message.obtain((Handler)this.decodeThread.getHandler(), (int)70002);
        quit.sendToTarget();
        try {
            this.decodeThread.join(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(70003);
        this.removeMessages(70004);
    }

    private void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            this.mZXingFacade.getCameraManager().requestPreviewFrame(this.decodeThread.getHandler(), 70001);
        }
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

