/*
 * Decompiled with CFR 0.152.
 */
package com.bottlerocketstudios.barcode.detection.controller;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.bottlerocketstudios.barcode.detection.camera.CameraManager;
import com.bottlerocketstudios.barcode.detection.controller.AmbientLightManager;
import com.bottlerocketstudios.barcode.detection.controller.IDecodeHandlerListener;
import com.bottlerocketstudios.barcode.detection.controller.ZXingFacadeHandler;
import com.bottlerocketstudios.barcode.detection.controller.ZXingFacadeListener;
import com.bottlerocketstudios.barcode.detection.model.ZXingConfiguration;
import com.google.zxing.Result;
import com.google.zxing.ResultPointCallback;
import java.io.IOException;

public class ZXingFacade
implements IDecodeHandlerListener {
    private static final String TAG = ZXingFacade.class.getSimpleName();
    private final Context mContext;
    private final AmbientLightManager mAmbientLightManager;
    private final ZXingConfiguration mZXingConfiguration;
    private CameraManager mCameraManager;
    private SurfaceView mSurfaceView;
    private boolean mHasSurface;
    private ZXingFacadeHandler mDecodeHandler;
    private ZXingFacadeListener mZXingFacadeListener;
    private ResultPointCallback mResultPointCallback;
    private SurfaceHolder.Callback mSurfaceHolderCallback = new SurfaceHolder.Callback(){

        public void surfaceCreated(SurfaceHolder surfaceHolder) {
            if (surfaceHolder == null) {
                Log.e((String)TAG, (String)"*** WARNING *** surfaceCreated() gave us a null surface!");
            }
            if (!ZXingFacade.this.mHasSurface) {
                ZXingFacade.this.mHasSurface = true;
                ZXingFacade.this.initCamera(surfaceHolder);
            }
        }

        public void surfaceChanged(SurfaceHolder surfaceHolder, int i, int i2, int i3) {
        }

        public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        }
    };

    public ZXingFacade(Context context, ZXingConfiguration ZXingConfiguration2, ZXingFacadeListener listener) {
        this.mContext = context.getApplicationContext();
        this.mAmbientLightManager = new AmbientLightManager(this.mContext);
        this.mZXingConfiguration = ZXingConfiguration2;
        this.mZXingFacadeListener = listener;
    }

    public void onCreate(SurfaceView surfaceView) {
        this.mSurfaceView = surfaceView;
        this.mHasSurface = false;
    }

    public void onResume() {
        this.mCameraManager = new CameraManager(this.mContext, this.mZXingConfiguration);
        SurfaceHolder surfaceHolder = this.mSurfaceView.getHolder();
        if (this.mHasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback(this.mSurfaceHolderCallback);
        }
        this.mAmbientLightManager.start(this.mCameraManager);
    }

    public void onPause() {
        if (this.mDecodeHandler != null) {
            this.mDecodeHandler.quitSynchronously();
            this.mDecodeHandler = null;
        }
        this.mAmbientLightManager.stop();
        this.mCameraManager.closeDriver();
        if (!this.mHasSurface) {
            this.mSurfaceView.getHolder().removeCallback(this.mSurfaceHolderCallback);
        }
    }

    @Override
    public CameraManager getCameraManager() {
        return this.mCameraManager;
    }

    @Override
    public Handler getHandler() {
        return this.mDecodeHandler;
    }

    public void handleDecode(Result rawResult, Bitmap barcode, float scaleFactor) {
        this.mZXingFacadeListener.handleDecode(rawResult, barcode, scaleFactor);
    }

    public void restartPreviewAfterDelay(long delayMS) {
        if (this.getHandler() != null) {
            this.getHandler().sendEmptyMessageDelayed(70005, delayMS);
        }
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            throw new IllegalStateException("No SurfaceHolder provided");
        }
        if (this.mCameraManager.isOpen()) {
            Log.w((String)TAG, (String)"initCamera() while already open -- late SurfaceView callback?");
            return;
        }
        try {
            this.mCameraManager.openDriver(surfaceHolder);
            if (this.getHandler() == null) {
                this.mDecodeHandler = new ZXingFacadeHandler(this, this.mResultPointCallback, this.mZXingConfiguration);
            }
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (Throwable)ioe);
            this.mZXingFacadeListener.onZXingException(ioe);
        }
        catch (RuntimeException e) {
            Log.w((String)TAG, (String)"Unexpected error initializing camera", (Throwable)e);
            this.mZXingFacadeListener.onZXingException(e);
        }
    }

    public void setResultPointCallback(ResultPointCallback resultPointCallback) {
        this.mResultPointCallback = resultPointCallback;
    }

    public void toggleFlash() {
        if (this.mCameraManager != null) {
            boolean flashEnabled = this.mCameraManager.getTorch();
            this.mCameraManager.setTorch(!flashEnabled);
        }
    }
}

