/*
 * Decompiled with CFR 0.152.
 */
package com.bottlerocketstudios.barcode.detection.controller;

import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import com.bottlerocketstudios.barcode.detection.controller.DecodeHandler;
import com.bottlerocketstudios.barcode.detection.controller.IDecodeHandlerListener;
import com.bottlerocketstudios.barcode.detection.model.DecodeFormatManager;
import com.bottlerocketstudios.barcode.detection.model.ZXingConfiguration;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.ResultPointCallback;
import java.util.Collection;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

final class DecodeThread<T>
extends Thread {
    private static final String TAG = DecodeThread.class.getSimpleName();
    public static final String BARCODE_BITMAP = "barcode_bitmap";
    public static final String BARCODE_SCALED_FACTOR = "barcode_scaled_factor";
    private final IDecodeHandlerListener mDecodeHandlerListener;
    private final Map<DecodeHintType, Object> hints;
    private Handler handler;
    private final CountDownLatch handlerInitLatch;

    DecodeThread(IDecodeHandlerListener decodeHandlerListener, ResultPointCallback resultPointCallback, ZXingConfiguration ZXingConfiguration2) {
        Collection<BarcodeFormat> decodeFormats;
        this.mDecodeHandlerListener = decodeHandlerListener;
        this.handlerInitLatch = new CountDownLatch(1);
        this.hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        if (ZXingConfiguration2.getBaseHints() != null) {
            this.hints.putAll(ZXingConfiguration2.getBaseHints());
        }
        if ((decodeFormats = ZXingConfiguration2.getDecodeFormats()) == null || decodeFormats.isEmpty()) {
            decodeFormats = EnumSet.noneOf(BarcodeFormat.class);
            if (ZXingConfiguration2.getBoolean("preferences_decode_1D_product", true)) {
                decodeFormats.addAll(DecodeFormatManager.PRODUCT_FORMATS);
            }
            if (ZXingConfiguration2.getBoolean("preferences_decode_1D_industrial", true)) {
                decodeFormats.addAll(DecodeFormatManager.INDUSTRIAL_FORMATS);
            }
            if (ZXingConfiguration2.getBoolean("preferences_decode_QR", true)) {
                decodeFormats.addAll(DecodeFormatManager.QR_CODE_FORMATS);
            }
            if (ZXingConfiguration2.getBoolean("preferences_decode_Data_Matrix", true)) {
                decodeFormats.addAll(DecodeFormatManager.DATA_MATRIX_FORMATS);
            }
            if (ZXingConfiguration2.getBoolean("preferences_decode_Aztec", false)) {
                decodeFormats.addAll(DecodeFormatManager.AZTEC_FORMATS);
            }
            if (ZXingConfiguration2.getBoolean("preferences_decode_PDF417", false)) {
                decodeFormats.addAll(DecodeFormatManager.PDF417_FORMATS);
            }
        }
        this.hints.put(DecodeHintType.POSSIBLE_FORMATS, decodeFormats);
        if (ZXingConfiguration2.getCharacterSet() != null) {
            this.hints.put(DecodeHintType.CHARACTER_SET, ZXingConfiguration2.getCharacterSet());
        }
        this.hints.put(DecodeHintType.NEED_RESULT_POINT_CALLBACK, resultPointCallback);
        Log.i((String)TAG, (String)("Hints: " + this.hints));
    }

    Handler getHandler() {
        try {
            this.handlerInitLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.handler;
    }

    @Override
    public void run() {
        Looper.prepare();
        this.handler = new DecodeHandler(this.mDecodeHandlerListener, this.hints);
        this.handlerInitLatch.countDown();
        Looper.loop();
    }
}

