/*
 * Decompiled with CFR 0.152.
 */
package com.bottlerocketstudios.barcode.detection.camera.open;

import android.hardware.Camera;
import android.util.Log;

public final class OpenCameraInterface {
    private static final String TAG = OpenCameraInterface.class.getName();

    private OpenCameraInterface() {
    }

    public static Camera open(int cameraId) {
        Camera camera;
        boolean explicitRequest;
        int numCameras = Camera.getNumberOfCameras();
        if (numCameras == 0) {
            Log.w((String)TAG, (String)"No cameras!");
            return null;
        }
        boolean bl = explicitRequest = cameraId >= 0;
        if (!explicitRequest) {
            int index;
            for (index = 0; index < numCameras; ++index) {
                Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)index, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing == 0) break;
            }
            cameraId = index;
        }
        if (cameraId < numCameras) {
            Log.i((String)TAG, (String)("Opening camera #" + cameraId));
            camera = Camera.open((int)cameraId);
        } else if (explicitRequest) {
            Log.w((String)TAG, (String)("Requested camera does not exist: " + cameraId));
            camera = null;
        } else {
            Log.i((String)TAG, (String)"No camera facing back; returning camera #0");
            camera = Camera.open((int)0);
        }
        return camera;
    }

    public static Camera open() {
        return OpenCameraInterface.open(-1);
    }
}

