/*
 * Decompiled with CFR 0.152.
 */
package com.bottlerocketstudios.barcode.detection.camera;

import android.graphics.Point;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.bottlerocketstudios.barcode.detection.camera.CameraConfigurationManager;

final class PreviewCallback
implements Camera.PreviewCallback {
    private static final String TAG = PreviewCallback.class.getSimpleName();
    private final CameraConfigurationManager configManager;
    private Handler previewHandler;
    private int previewMessage;

    PreviewCallback(CameraConfigurationManager configManager) {
        this.configManager = configManager;
    }

    void setHandler(Handler previewHandler, int previewMessage) {
        this.previewHandler = previewHandler;
        this.previewMessage = previewMessage;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        Point cameraResolution = this.configManager.getCameraResolution();
        Handler thePreviewHandler = this.previewHandler;
        if (cameraResolution != null && thePreviewHandler != null) {
            Message message = thePreviewHandler.obtainMessage(this.previewMessage, cameraResolution.x, cameraResolution.y, (Object)data);
            message.sendToTarget();
            this.previewHandler = null;
        } else {
            Log.d((String)TAG, (String)"Got preview callback, but no handler or resolution available");
        }
    }
}

