/*
 * Decompiled with CFR 0.152.
 */
package com.bottlerocketstudios.barcode.detection.camera;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.util.Log;
import android.view.Display;
import android.view.WindowManager;
import com.bottlerocketstudios.barcode.detection.camera.FrontLightMode;
import com.bottlerocketstudios.barcode.detection.model.ZXingConfiguration;
import com.google.zxing.client.android.camera.CameraConfigurationUtils;

final class CameraConfigurationManager {
    private static final String TAG = "CameraConfiguration";
    private final Context context;
    private Point screenResolution;
    private Point cameraResolution;
    private ZXingConfiguration mZXingConfiguration;

    CameraConfigurationManager(Context context, ZXingConfiguration ZXingConfiguration2) {
        this.context = context;
        this.mZXingConfiguration = ZXingConfiguration2;
    }

    void initFromCameraParameters(Camera camera) {
        Camera.Parameters parameters = camera.getParameters();
        WindowManager manager = (WindowManager)this.context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        Point theScreenResolution = new Point();
        display.getSize(theScreenResolution);
        this.screenResolution = theScreenResolution;
        Log.i((String)TAG, (String)("Screen resolution: " + this.screenResolution));
        this.cameraResolution = CameraConfigurationUtils.findBestPreviewSizeValue((Camera.Parameters)parameters, (Point)this.screenResolution);
        Log.i((String)TAG, (String)("Camera resolution: " + this.cameraResolution));
    }

    void setDesiredCameraParameters(Camera camera, boolean safeMode) {
        Camera.Parameters parameters = camera.getParameters();
        if (parameters == null) {
            Log.w((String)TAG, (String)"Device error: no camera parameters are available. Proceeding without configuration.");
            return;
        }
        Log.i((String)TAG, (String)("Initial camera parameters: " + parameters.flatten()));
        if (safeMode) {
            Log.w((String)TAG, (String)"In camera config safe mode -- most settings will not be honored");
        }
        this.initializeTorch(parameters, safeMode);
        CameraConfigurationUtils.setFocus((Camera.Parameters)parameters, (boolean)this.mZXingConfiguration.getBoolean("preferences_auto_focus", true), (boolean)this.mZXingConfiguration.getBoolean("preferences_disable_continuous_focus", true), (boolean)safeMode);
        if (!safeMode) {
            if (this.mZXingConfiguration.getBoolean("preferences_invert_scan", false)) {
                CameraConfigurationUtils.setInvertColor((Camera.Parameters)parameters);
            }
            if (!this.mZXingConfiguration.getBoolean("preferences_disable_barcode_scene_mode", true)) {
                CameraConfigurationUtils.setBarcodeSceneMode((Camera.Parameters)parameters);
            }
            if (!this.mZXingConfiguration.getBoolean("preferences_disable_metering", true)) {
                CameraConfigurationUtils.setVideoStabilization((Camera.Parameters)parameters);
                CameraConfigurationUtils.setFocusArea((Camera.Parameters)parameters);
                CameraConfigurationUtils.setMetering((Camera.Parameters)parameters);
            }
        }
        parameters.setPreviewSize(this.cameraResolution.x, this.cameraResolution.y);
        Log.i((String)TAG, (String)("Final camera parameters: " + parameters.flatten()));
        camera.setParameters(parameters);
        Camera.Parameters afterParameters = camera.getParameters();
        Camera.Size afterSize = afterParameters.getPreviewSize();
        if (afterSize != null && (this.cameraResolution.x != afterSize.width || this.cameraResolution.y != afterSize.height)) {
            Log.w((String)TAG, (String)("Camera said it supported preview size " + this.cameraResolution.x + 'x' + this.cameraResolution.y + ", but after setting it, preview size is " + afterSize.width + 'x' + afterSize.height));
            this.cameraResolution.x = afterSize.width;
            this.cameraResolution.y = afterSize.height;
        }
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    Point getScreenResolution() {
        return this.screenResolution;
    }

    boolean getTorchState(Camera camera) {
        Camera.Parameters parameters;
        if (camera != null && (parameters = camera.getParameters()) != null) {
            String flashMode = parameters.getFlashMode();
            return flashMode != null && ("on".equals(flashMode) || "torch".equals(flashMode));
        }
        return false;
    }

    void setTorch(Camera camera, boolean newSetting) {
        Camera.Parameters parameters = camera.getParameters();
        this.doSetTorch(parameters, newSetting, false);
        camera.setParameters(parameters);
    }

    private void initializeTorch(Camera.Parameters parameters, boolean safeMode) {
        boolean currentSetting = FrontLightMode.readPref(this.mZXingConfiguration) == FrontLightMode.ON;
        this.doSetTorch(parameters, currentSetting, safeMode);
    }

    private void doSetTorch(Camera.Parameters parameters, boolean newSetting, boolean safeMode) {
        CameraConfigurationUtils.setTorch((Camera.Parameters)parameters, (boolean)newSetting);
        if (!safeMode && !this.mZXingConfiguration.getBoolean("preferences_disable_exposure", true)) {
            CameraConfigurationUtils.setBestExposure((Camera.Parameters)parameters, (boolean)newSetting);
        }
    }
}

