package com.nanorep.accessibility.components

import android.content.Context
import android.graphics.drawable.AnimationDrawable
import android.graphics.drawable.StateListDrawable
import android.util.AttributeSet
import android.view.ViewGroup
import android.widget.TextView
import com.nanorep.accessibility.R
import com.nanorep.accessibility.voice.SpeechedTextListener
import com.nanorep.accessibility.voice.VoiceRecognition
import com.nanorep.accessibility.voice.engines.SpeechToText
import com.nanorep.sdkcore.utils.NRError
import com.nanorep.sdkcore.utils.searchForView

/**
 * Created by tehila on 27/11/2017.
 *
 * provides a UI component that already can work and handle voice recognition engine.
 *
 * This implementation currently uses only the Android given SpeechRecognizer engine.
 */
 open class SpeecherView(context: Context, attributes: AttributeSet?) : ViewGroup(context, attributes), SpeechedTextListener {

    protected val voiceRecognition : VoiceRecognition = VoiceRecognition.create(context, init = {
       speechAdminister { SpeechToText(context) }
       speechListener{this@SpeecherView}
       bindActionView { this@SpeecherView }
   })

    private var textId: Int = -1
    private var textView: TextView? = null

    protected var innerListener: SpeechedTextListener? = null
    private var myClickListener: OnClickListener? = null


    init {
        if(attributes != null) {
            val a = context.obtainStyledAttributes(attributes, R.styleable.SpeecherView, 0, 0)
            try {
                textId = a.getResourceId(R.styleable.SpeecherView_textView, -1)
                id = -1
            } catch (e: Exception) {
                textView = null
            } finally {
                a?.recycle()
            }
        }

        isClickable = true
        isFocusable = false
        isFocusableInTouchMode = false
    }


    override fun onLayout(changed: Boolean, l: Int, t: Int, r: Int, b: Int) {

    }

     fun bindOutputView(textView: TextView){
        this.textView = textView
    }

    open fun registerListener(listener: SpeechedTextListener?){
        this.innerListener = listener
    }

     override fun onPartialResults(text: String) {
        innerListener?.onPartialResults(text)
        textView?.text = text
    }

    override fun onResults(text: String) {
        innerListener?.onResults(text)
        textView?.text = text
    }

    override fun onActive() {
        innerListener?.onActive()
    }

    override fun onPrepared() {
        innerListener?.onPrepared()
    }

    override fun onStart() {
        innerListener?.onStart()
    }

    override fun onStop() {
        innerListener?.onStop()
    }

    override fun onAttachedToWindow() {
        super.onAttachedToWindow()
        if(textId != -1){
            textView = (this.parent as ViewGroup).searchForView(textId) as TextView?
        }
    }

    override fun onError(error: NRError) {
        innerListener?.onError(error)
    }

    fun release(){
        isEnabled = false
        voiceRecognition.release()
        innerListener = null
        myClickListener = null
        textView = null
    }

    fun cancelSpeech(){
        voiceRecognition.speechAdminister?.cancel()
        innerListener?.onCancel()
    }

    /**
     * will stop current recording and will pass the results that were accumulated up to now
     */
    fun stop() {
        voiceRecognition.speechAdminister?.stop()
    }


    override fun setOnClickListener(l: OnClickListener?) {
        super.setOnClickListener(l)
        this.myClickListener = l
    }

    fun getOnClickListener() : OnClickListener? {
        return this.myClickListener
    }
}