/*
 * Decompiled with CFR 0.152.
 */
package com.zm.app.zxing.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import com.google.zxing.ResultPoint;
import com.zm.app.zxing.R;
import com.zm.app.zxing.camera.CameraManager;
import java.util.Collection;
import java.util.HashSet;

public final class ViewfinderView
extends View {
    public static boolean statusFlag = true;
    private int sign;
    private static final long ANIMATION_DELAY = 10L;
    private static final int OPAQUE = 255;
    private int ScreenRate;
    private static final int CORNER_WIDTH = 10;
    private static final int SPEEN_DISTANCE = 5;
    private static float density;
    private static final int TEXT_SIZE = 16;
    private static final int TEXT_PADDING_TOP = 30;
    private Paint paint;
    private int slideTop;
    private float x;
    private float y;
    private int tuX;
    private int tuY;
    private Bitmap resultBitmap;
    private final int maskColor;
    private final int resultColor;
    private final int resultPointColor;
    private Collection<ResultPoint> possibleResultPoints;
    private Collection<ResultPoint> lastPossibleResultPoints;
    boolean isFirst;

    public ViewfinderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        density = context.getResources().getDisplayMetrics().density;
        this.ScreenRate = (int)(20.0f * density);
        this.paint = new Paint();
        Resources resources = this.getResources();
        this.maskColor = resources.getColor(R.color.viewfinder_mask);
        this.resultColor = resources.getColor(R.color.result_view);
        this.resultPointColor = resources.getColor(R.color.possible_result_points);
        this.possibleResultPoints = new HashSet<ResultPoint>(5);
    }

    @SuppressLint(value={"DrawAllocation"})
    public void onDraw(Canvas canvas) {
        Rect frame = CameraManager.get().getFramingRect();
        if (frame == null) {
            return;
        }
        if (!this.isFirst) {
            this.isFirst = true;
            this.slideTop = frame.top;
        }
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        this.paint.setColor(this.resultBitmap != null ? this.resultColor : this.maskColor);
        canvas.drawRect(0.0f, 0.0f, (float)width, (float)frame.top, this.paint);
        canvas.drawRect(0.0f, (float)frame.top, (float)frame.left, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect((float)(frame.right + 1), (float)frame.top, (float)width, (float)(frame.bottom + 1), this.paint);
        canvas.drawRect(0.0f, (float)(frame.bottom + 1), (float)width, (float)height, this.paint);
        if (this.resultBitmap != null) {
            this.paint.setAlpha(255);
            canvas.drawBitmap(this.resultBitmap, (float)frame.left, (float)frame.top, this.paint);
        } else {
            this.paint.setColor(-16711936);
            canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + this.ScreenRate), (float)(frame.top + 10), this.paint);
            canvas.drawRect((float)frame.left, (float)frame.top, (float)(frame.left + 10), (float)(frame.top + this.ScreenRate), this.paint);
            canvas.drawRect((float)(frame.right - this.ScreenRate), (float)frame.top, (float)frame.right, (float)(frame.top + 10), this.paint);
            canvas.drawRect((float)(frame.right - 10), (float)frame.top, (float)frame.right, (float)(frame.top + this.ScreenRate), this.paint);
            canvas.drawRect((float)frame.left, (float)(frame.bottom - 10), (float)(frame.left + this.ScreenRate), (float)frame.bottom, this.paint);
            canvas.drawRect((float)frame.left, (float)(frame.bottom - this.ScreenRate), (float)(frame.left + 10), (float)frame.bottom, this.paint);
            canvas.drawRect((float)(frame.right - this.ScreenRate), (float)(frame.bottom - 10), (float)frame.right, (float)frame.bottom, this.paint);
            canvas.drawRect((float)(frame.right - 10), (float)(frame.bottom - this.ScreenRate), (float)frame.right, (float)frame.bottom, this.paint);
            this.slideTop += 5;
            if (this.slideTop >= frame.bottom) {
                this.slideTop = frame.top;
            }
            Rect lineRect = new Rect();
            lineRect.left = frame.left;
            lineRect.right = frame.right;
            lineRect.top = this.slideTop;
            lineRect.bottom = this.slideTop + 18;
            canvas.drawBitmap(((BitmapDrawable)this.getResources().getDrawable(R.drawable.scan_line)).getBitmap(), null, lineRect, this.paint);
            this.paint.setColor(-1);
            this.paint.setTextSize(16.0f * density);
            float mtw = this.paint.measureText(this.getResources().getString(R.string.scan_text));
            float tx = ((float)width - mtw) / 2.0f;
            canvas.drawText(this.getResources().getString(R.string.scan_text), tx, (float)frame.top - 30.0f * density, this.paint);
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.deng_09);
            this.tuX = bitmap.getWidth();
            this.tuY = bitmap.getHeight();
            this.x = canvas.getWidth() / 2 - bitmap.getWidth() / 2;
            this.y = (float)frame.bottom + 30.0f * density;
            canvas.drawBitmap(bitmap, this.x, this.y, this.paint);
            canvas.restore();
            Collection<ResultPoint> currentPossible = this.possibleResultPoints;
            Collection<ResultPoint> currentLast = this.lastPossibleResultPoints;
            if (currentPossible.isEmpty()) {
                this.lastPossibleResultPoints = null;
            } else {
                this.possibleResultPoints = new HashSet<ResultPoint>(5);
                this.lastPossibleResultPoints = currentPossible;
                this.paint.setAlpha(255);
                this.paint.setColor(this.resultPointColor);
                for (ResultPoint point : currentPossible) {
                    canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 6.0f, this.paint);
                }
            }
            if (currentLast != null) {
                this.paint.setAlpha(127);
                this.paint.setColor(this.resultPointColor);
                for (ResultPoint point : currentLast) {
                    canvas.drawCircle((float)frame.left + point.getX(), (float)frame.top + point.getY(), 3.0f, this.paint);
                }
            }
            this.postInvalidateDelayed(10L, frame.left, frame.top, frame.right, frame.bottom);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (event.getAction() != 0) {
            return true;
        }
        if (this.x <= event.getX() && event.getX() <= this.x + (float)this.tuX && event.getY() >= this.y && event.getY() <= this.y + (float)this.tuY) {
            if (this.sign % 2 == 0) {
                CameraManager.get().openF();
            } else {
                CameraManager.get().stopF();
            }
            ++this.sign;
        }
        return false;
    }

    public void drawViewfinder() {
        this.resultBitmap = null;
        this.invalidate();
    }

    public void drawResultBitmap(Bitmap barcode) {
        this.resultBitmap = barcode;
        this.invalidate();
    }

    public void addPossibleResultPoint(ResultPoint point) {
        this.possibleResultPoints.add(point);
    }

    public static int px2Dip(Context context, int px) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)((float)px / scale + 0.5f * (float)(px >= 0 ? 1 : -1));
    }
}

