/*
 * Decompiled with CFR 0.152.
 */
package com.zm.app.zxing.camera;

import android.content.Context;
import android.graphics.Point;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.os.Handler;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.View;
import android.widget.Toast;
import com.zm.app.zxing.camera.AutoFocusCallback;
import com.zm.app.zxing.camera.CameraConfigurationManager;
import com.zm.app.zxing.camera.FlashlightManager;
import com.zm.app.zxing.camera.PlanarYUVLuminanceSource;
import com.zm.app.zxing.camera.PreviewCallback;
import java.io.IOException;
import java.util.List;

public final class CameraManager {
    private static final String TAG = CameraManager.class.getSimpleName();
    private static CameraManager cameraManager;
    private final Context context;
    private final CameraConfigurationManager configManager;
    private Camera camera;
    private Rect framingRect;
    private Rect framingRectInPreview;
    private boolean initialized;
    private boolean previewing;
    private final boolean useOneShotPreviewCallback;
    private View mView;
    private boolean isLand;
    private final PreviewCallback previewCallback;
    private final AutoFocusCallback autoFocusCallback;

    public static void init(Context context, View view, boolean isLand) {
        if (cameraManager == null) {
            cameraManager = new CameraManager(context, view, isLand);
        }
    }

    public static void init(Context context) {
        if (cameraManager == null) {
            cameraManager = new CameraManager(context);
        }
    }

    public static CameraManager get() {
        return cameraManager;
    }

    public CameraManager(Context context) {
        this.mView = null;
        this.isLand = false;
        this.context = context;
        this.configManager = new CameraConfigurationManager(context, this.mView);
        this.useOneShotPreviewCallback = Build.VERSION.SDK_INT > 3;
        this.previewCallback = new PreviewCallback(this.configManager, this.useOneShotPreviewCallback);
        this.autoFocusCallback = new AutoFocusCallback();
    }

    public CameraManager(Context context, View view, boolean isLand) {
        this.mView = view;
        this.isLand = isLand;
        this.context = context;
        this.configManager = new CameraConfigurationManager(context, this.mView);
        this.useOneShotPreviewCallback = Build.VERSION.SDK_INT > 3;
        this.previewCallback = new PreviewCallback(this.configManager, this.useOneShotPreviewCallback);
        this.autoFocusCallback = new AutoFocusCallback();
    }

    public void openDriver(SurfaceHolder holder) throws IOException {
        if (this.camera == null) {
            this.camera = Camera.open();
            if (this.camera == null) {
                throw new IOException();
            }
            this.camera.setPreviewDisplay(holder);
            if (!this.initialized) {
                this.initialized = true;
                this.configManager.initFromCameraParameters(this.camera);
            }
            this.configManager.setDesiredCameraParameters(this.camera, this.isLand);
            FlashlightManager.enableFlashlight();
        }
    }

    public void closeDriver() {
        if (this.camera != null) {
            FlashlightManager.disableFlashlight();
            this.camera.release();
            this.camera = null;
        }
    }

    public void startPreview() {
        if (this.camera != null && !this.previewing) {
            this.camera.startPreview();
            this.previewing = true;
        }
    }

    public void stopPreview() {
        if (this.camera != null && this.previewing) {
            if (!this.useOneShotPreviewCallback) {
                this.camera.setPreviewCallback(null);
            }
            this.camera.stopPreview();
            this.previewCallback.setHandler(null, 0);
            this.autoFocusCallback.setHandler(null, 0);
            this.previewing = false;
        }
    }

    public void requestPreviewFrame(Handler handler, int message) {
        if (this.camera != null && this.previewing) {
            this.previewCallback.setHandler(handler, message);
            if (this.useOneShotPreviewCallback) {
                this.camera.setOneShotPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            } else {
                this.camera.setPreviewCallback((Camera.PreviewCallback)this.previewCallback);
            }
        }
    }

    public void requestAutoFocus(Handler handler, int message) {
        if (this.camera != null && this.previewing) {
            this.autoFocusCallback.setHandler(handler, message);
            this.camera.autoFocus((Camera.AutoFocusCallback)this.autoFocusCallback);
        }
    }

    public Rect getFramingRect() {
        Point screenResolution = this.configManager.getScreenResolution();
        if (this.framingRect == null) {
            if (this.camera == null) {
                return null;
            }
            int width = screenResolution.x * 56 / 100;
            if (this.isLand) {
                width = screenResolution.x * 46 / 100;
            }
            int height = width;
            int leftOffset = (screenResolution.x - width) / 2;
            int topOffset = (screenResolution.y - height) / 2;
            this.framingRect = new Rect(leftOffset, topOffset, leftOffset + width, topOffset + height);
            Log.d((String)TAG, (String)("Calculated framing rect: " + this.framingRect));
        }
        return this.framingRect;
    }

    public Rect getFramingRectInPreview() {
        if (this.framingRectInPreview == null) {
            Rect rect = new Rect(this.getFramingRect());
            Point cameraResolution = this.configManager.getCameraResolution();
            Point screenResolution = this.configManager.getScreenResolution();
            rect.left = rect.left * cameraResolution.y / screenResolution.x;
            rect.right = rect.right * cameraResolution.y / screenResolution.x;
            rect.top = rect.top * cameraResolution.x / screenResolution.y;
            rect.bottom = rect.bottom * cameraResolution.x / screenResolution.y;
            this.framingRectInPreview = rect;
        }
        return this.framingRectInPreview;
    }

    public PlanarYUVLuminanceSource buildLuminanceSource(byte[] data, int width, int height) {
        Rect rect = this.getFramingRectInPreview();
        int previewFormat = this.configManager.getPreviewFormat();
        String previewFormatString = this.configManager.getPreviewFormatString();
        switch (previewFormat) {
            case 16: 
            case 17: {
                return new PlanarYUVLuminanceSource(data, width, height, rect.left, rect.top, rect.width(), rect.height());
            }
        }
        if ("yuv420p".equals(previewFormatString)) {
            return new PlanarYUVLuminanceSource(data, width, height, rect.left, rect.top, rect.width(), rect.height());
        }
        throw new IllegalArgumentException("Unsupported picture format: " + previewFormat + '/' + previewFormatString);
    }

    public Context getContext() {
        return this.context;
    }

    public void openF() {
        Camera.Parameters params = this.camera.getParameters();
        if (this.camera == null) {
            Toast.makeText((Context)this.context, (CharSequence)"Camera not found", (int)1);
            return;
        }
        Camera.Parameters parameters = this.camera.getParameters();
        if (parameters == null) {
            return;
        }
        List flashModes = parameters.getSupportedFlashModes();
        if (flashModes == null) {
            return;
        }
        String flashMode = parameters.getFlashMode();
        if (!"torch".equals(flashMode)) {
            if (flashModes.contains("torch")) {
                parameters.setFlashMode("torch");
                this.camera.setParameters(parameters);
            } else {
                Toast.makeText((Context)this.context, (CharSequence)"Flash mode (torch) not supported", (int)1);
            }
        }
    }

    public void stopF() {
        if (this.camera == null) {
            System.out.println("ssss");
            return;
        }
        System.out.println("parameters");
        Camera.Parameters parameters = this.camera.getParameters();
        if (parameters == null) {
            System.out.println("parameters == null");
            return;
        }
        List flashModes = parameters.getSupportedFlashModes();
        String flashMode = parameters.getFlashMode();
        if (flashModes == null) {
            return;
        }
        Log.i((String)TAG, (String)("Flash mode: " + flashMode));
        Log.i((String)TAG, (String)("Flash modes: " + flashModes));
        if (!"off".equals(flashMode)) {
            if (flashModes.contains("off")) {
                parameters.setFlashMode("off");
                this.camera.setParameters(parameters);
            } else {
                Log.e((String)TAG, (String)"FLASH_MODE_OFF not supported");
            }
        }
    }
}

