/*
 * Decompiled with CFR 0.152.
 */
package com.example.qrcode;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Vibrator;
import android.util.Log;
import android.view.MenuItem;
import android.view.SurfaceHolder;
import android.view.View;
import android.widget.Button;
import android.widget.Toast;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.zm.app.zxing.IScanProcesse;
import com.zm.app.zxing.R;
import com.zm.app.zxing.camera.CameraManager;
import com.zm.app.zxing.decoding.CaptureActivityHandler;
import com.zm.app.zxing.decoding.InactivityTimer;
import com.zm.app.zxing.view.ViewfinderView;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Vector;

public class MipcaActivityCapture
extends Activity
implements SurfaceHolder.Callback,
IScanProcesse {
    private CaptureActivityHandler handler;
    private ViewfinderView viewfinderView;
    private boolean hasSurface;
    private Vector<BarcodeFormat> decodeFormats;
    private String characterSet;
    private InactivityTimer inactivityTimer;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private static final float BEEP_VOLUME = 0.1f;
    private boolean vibrate;
    private static final long VIBRATE_DURATION = 200L;
    private final MediaPlayer.OnCompletionListener beepListener = new MediaPlayer.OnCompletionListener(){

        public void onCompletion(MediaPlayer mediaPlayer) {
            mediaPlayer.seekTo(0);
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_capture);
        this.viewfinderView = (ViewfinderView)this.findViewById(R.id.viewfinder_view);
        Button mButtonBack = (Button)this.findViewById(R.id.button_back);
        mButtonBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MipcaActivityCapture.this.finish();
            }
        });
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer(this);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.finish();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private String saveBitmapToFile(Bitmap barcode) {
        Log.v((String)"\u4fdd\u5b58\u6587\u4ef6", (String)(new Date().getTime() + ">>1"));
        String dirpath = Environment.getExternalStorageDirectory() + "/barcode";
        File dir = new File(dirpath);
        dir.mkdirs();
        File file = new File(dirpath + "/" + new Date().getTime() + ".png");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(file);
            barcode.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file.getAbsolutePath();
    }

    @Override
    public void handleDecode(Result result, Bitmap barcode) {
        this.inactivityTimer.onActivity();
        this.playBeepSoundAndVibrate();
        String resultString = result.getText();
        if (resultString.equals("")) {
            Toast.makeText((Context)this, (CharSequence)"Scan failed!", (int)0).show();
        } else {
            Intent resultIntent = new Intent();
            Bundle bundle = new Bundle();
            bundle.putString("result", resultString);
            bundle.putString("bitmap", this.saveBitmapToFile(barcode));
            resultIntent.putExtras(bundle);
            this.setResult(-1, resultIntent);
        }
        this.finish();
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        try {
            CameraManager.get().openDriver(surfaceHolder);
        }
        catch (IOException ioe) {
            return;
        }
        catch (RuntimeException e) {
            return;
        }
        if (this.handler == null) {
            this.handler = new CaptureActivityHandler(this, this.decodeFormats, this.characterSet);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    @Override
    public ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    @Override
    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    private void initBeepSound() {
        if (this.playBeep && this.mediaPlayer == null) {
            this.setVolumeControlStream(3);
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setAudioStreamType(3);
            this.mediaPlayer.setOnCompletionListener(this.beepListener);
            AssetFileDescriptor file = this.getResources().openRawResourceFd(R.raw.beep);
            try {
                this.mediaPlayer.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
                file.close();
                this.mediaPlayer.setVolume(0.1f, 0.1f);
                this.mediaPlayer.prepare();
            }
            catch (IOException e) {
                this.mediaPlayer = null;
            }
        }
    }

    private void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            Vibrator vibrator = (Vibrator)this.getSystemService("vibrator");
            vibrator.vibrate(200L);
        }
    }

    @Override
    public void returnScanResult(int resultOk, Intent obj) {
        this.setResult(resultOk, obj);
        this.finish();
    }

    @Override
    public void GotProductQueryMessage(String url) {
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
        intent.addFlags(524288);
        this.startActivity(intent);
    }
}

