
package com.zm.app.zxing.decoding;

import java.util.Vector;

import android.app.Activity;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

import com.example.qrcode.MipcaActivityCapture;
import com.zm.app.zxing.IScanProcesse;
import com.zm.app.zxing.R;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.zm.app.zxing.camera.CameraManager;
import com.zm.app.zxing.view.ViewfinderResultPointCallback;

public final class CaptureActivityHandler extends Handler {

  private static final String TAG = CaptureActivityHandler.class.getSimpleName();

  private final IScanProcesse mScanProcesse;
  private final DecodeThread decodeThread;
  private State state;

  private enum State {
    PREVIEW,
    SUCCESS,
    DONE
  }

  public CaptureActivityHandler(IScanProcesse scanProcesse, Vector<BarcodeFormat> decodeFormats,
      String characterSet) {
    this.mScanProcesse = scanProcesse;
    decodeThread = new DecodeThread(mScanProcesse, decodeFormats, characterSet,
        new ViewfinderResultPointCallback(mScanProcesse.getViewfinderView()));
    decodeThread.start();
    state = State.SUCCESS;
    CameraManager.get().startPreview();
    restartPreviewAndDecode();
  }

  @Override
  public void handleMessage(Message message) {
	  if(message.what == R.id.auto_focus){
		  	if (state == State.PREVIEW) {
	          CameraManager.get().requestAutoFocus(this, R.id.auto_focus);
	        }
	  }else if(message.what == R.id.restart_preview){
		  	Log.d(TAG, "Got restart preview message");
	        restartPreviewAndDecode();
	  }else if(message.what == R.id.decode_succeeded){
		  	Log.d(TAG, "Got decode succeeded message");
	        state = State.SUCCESS;
	        Bundle bundle = message.getData();
	        Bitmap barcode = bundle == null ? null :
	            (Bitmap) bundle.getParcelable(DecodeThread.BARCODE_BITMAP);
	        
	        mScanProcesse.handleDecode((Result) message.obj, barcode);       
	  }else if(message.what == R.id.decode_failed){
		  	state = State.PREVIEW;
	        CameraManager.get().requestPreviewFrame(decodeThread.getHandler(), R.id.decode);
	  }else if(message.what == R.id.return_scan_result){
		  Log.d(TAG, "Got return scan result message");
		  mScanProcesse.returnScanResult(Activity.RESULT_OK, (Intent) message.obj);
	  }else if(message.what == R.id.launch_product_query){
		  Log.d(TAG, "Got product query message");
	        String url = (String) message.obj;
	        mScanProcesse.GotProductQueryMessage(url);
	  }
  }

  public void quitSynchronously() {
    state = State.DONE;
    CameraManager.get().stopPreview();
    Message quit = Message.obtain(decodeThread.getHandler(), R.id.quit);
    quit.sendToTarget();
    try {
      decodeThread.join();
    } catch (InterruptedException e) {
      // continue
    }

    // Be absolutely sure we don't send any queued up messages
    removeMessages(R.id.decode_succeeded);
    removeMessages(R.id.decode_failed);
  }

  private void restartPreviewAndDecode() {
    if (state == State.SUCCESS) {
      state = State.PREVIEW;
      CameraManager.get().requestPreviewFrame(decodeThread.getHandler(), R.id.decode);
      CameraManager.get().requestAutoFocus(this, R.id.auto_focus);
      mScanProcesse.drawViewfinder();
    }
  }

}
