package com.boanda.android.push.receive;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import com.boanda.android.push.PushDataCenter;
import com.boanda.android.push.PushProxy;

import org.json.JSONObject;

import cn.jpush.android.api.JPushInterface;

/**
 * Created by Administrator on 2017/6/15.
 */

public class JPushReceiver extends BroadcastReceiver {

    @Override
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        Bundle data = intent.getExtras();
        if(action == JPushInterface.ACTION_MESSAGE_RECEIVED){
            String bodyStr = data.getString(JPushInterface.EXTRA_MESSAGE);
            String msgId = data.getString(JPushInterface.EXTRA_MSG_ID);
            try {
                JSONObject bodyObject = new JSONObject(bodyStr);
                String title = bodyObject.optString(PushBody.KEY_TITLE);
                String message = bodyObject.optString(PushBody.KEY_MESSAGE);
                String businessAction = bodyObject.optString(PushBody.KEY_ACTION);
                String category = bodyObject.optString(PushBody.KEY_CATEGORY);
                long time = bodyObject.optLong(PushBody.KEY_TIME);
                JSONObject extraObject = bodyObject.optJSONObject(PushBody.KEY_EXTRA);
                PushBody pushBody = new PushBody()
                        .setMsgId(msgId)
                        .setTitle(title)
                        .setMessage(message)
                        .setAction(businessAction)
                        .setCategory(category)
                        .setTime(time)
                        .setExtra(extraObject == null ? null : extraObject.toString());
                PushDataCenter.save(pushBody);
                if (PushProxy.getDispatcher() != null) {
                    PushProxy.getDispatcher().dispatch(pushBody);
                }
            }catch (Exception e){
                e.printStackTrace();
            }
        }
    }
}
