package com.boanda.android.push;

import android.content.Context;

import com.boanda.android.push.receive.IMessageDispatcher;
import com.boanda.android.push.receive.PushBody;
import com.szboanda.android.platform.db.DbHelper;

import java.util.HashSet;

/**
 * 推送的代理类，用于隔离第三方SDK
 * Created by Administrator on 2017/6/15.
 */

public class PushProxy {

    private static Context mContext;

    private static IPushExecutor mPushExecutor;

    private static IMessageDispatcher mMessageDispatcher;

    private static String mAlias;

    /**
     * 初始化
     * @param context
     */
    public static void init(Context context, Class<?> executorCls){
        mContext = context;
        try{
            Object instance = executorCls.newInstance();
            if(instance instanceof IPushExecutor){
                mPushExecutor = (IPushExecutor)instance;
                mPushExecutor.init(context);
            }
            DbHelper.getDao().createTableIfNotExist(PushBody.class);
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    public static void setAlias(String alias){
        setAlias(alias, new DefaultSetCallback());
    }

    public static void setAlias(String alias, ISetCallback callback){
        mAlias = alias;
        if(mPushExecutor != null) {
            mPushExecutor.setAliasAndTags(alias, new HashSet<String>(), callback);
        }
    }

    public static Context getContext(){
        return mContext;
    }

    public static void registerDispatcher(IMessageDispatcher dispatcher){
        mMessageDispatcher = dispatcher;
    }

    public static IMessageDispatcher getDispatcher(){
        return mMessageDispatcher;
    }

    public static String getAlias(){
        return mAlias;
    }

}
