/*
 * Decompiled with CFR 0.152.
 */
package com.boanda.android.push.receive;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import cn.jpush.android.api.JPushInterface;
import com.boanda.android.push.PushDataCenter;
import com.boanda.android.push.PushProxy;
import com.boanda.android.push.receive.PushBody;
import org.json.JSONObject;

public class JPushReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        String action = intent.getAction();
        Bundle data = intent.getExtras();
        if (action == JPushInterface.ACTION_MESSAGE_RECEIVED) {
            String bodyStr = data.getString(JPushInterface.EXTRA_MESSAGE);
            String msgId = data.getString(JPushInterface.EXTRA_MSG_ID);
            try {
                JSONObject bodyObject = new JSONObject(bodyStr);
                String title = bodyObject.optString("title");
                String message = bodyObject.optString("message");
                String businessAction = bodyObject.optString("action");
                String category = bodyObject.optString("category");
                long time = bodyObject.optLong("time");
                JSONObject extraObject = bodyObject.optJSONObject("extra");
                PushBody pushBody = new PushBody().setMsgId(msgId).setTitle(title).setMessage(message).setAction(businessAction).setCategory(category).setTime(time).setExtra(extraObject.toString());
                PushDataCenter.save(pushBody);
                if (PushProxy.getDispatcher() != null) {
                    PushProxy.getDispatcher().dispatch(pushBody);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

