/*
 * Decompiled with CFR 0.152.
 */
package com.boanda.android.sync;

import android.util.Xml;
import com.boanda.android.sync.DataSyncField;
import com.boanda.android.sync.ISyncXmlParser;
import com.boanda.android.sync.SyncDaoAdapter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;

public class SyncXmlParser
implements ISyncXmlParser {
    private static final String TAG_TABLE = "table";
    private static final String TAG_REP_TIME = "response-time";
    private static final String TAG_FIELD = "field";
    private static final String TAG_DATA_ITEM = "data-item";
    private static final String TAG_DATA_FIELD = "data-field";
    private String encode = "UTF-8";
    private long responseTime;
    private List<DataSyncField> fields = null;
    private SyncDaoAdapter mDataSaver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean parseXml(File syncFile) {
        boolean isSuccess;
        block18: {
            this.mDataSaver = new SyncDaoAdapter();
            isSuccess = false;
            try {
                if (syncFile == null || !syncFile.exists()) break block18;
                XmlPullParser parser = Xml.newPullParser();
                InputStream input = null;
                try {
                    input = new BufferedInputStream(new FileInputStream(syncFile));
                    parser.setInput(input, this.encode);
                    int eventType = parser.getEventType();
                    while (eventType != 1) {
                        switch (eventType) {
                            case 0: {
                                this.fields = new ArrayList<DataSyncField>();
                                break;
                            }
                            case 2: {
                                this.parseTag(parser);
                                break;
                            }
                        }
                        eventType = parser.next();
                    }
                    this.mDataSaver.end();
                    isSuccess = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        input.close();
                        input = null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isSuccess;
    }

    private void parseTag(XmlPullParser parser) {
        try {
            String tagName = parser.getName();
            if (TAG_TABLE.equals(tagName)) {
                String tableName = parser.nextText();
                this.mDataSaver.setTableName(tableName);
            } else if (TAG_REP_TIME.equals(tagName)) {
                this.responseTime = Long.parseLong(parser.nextText());
            } else if (TAG_FIELD.equals(tagName)) {
                this.parseTableFields(parser);
            } else if (TAG_DATA_ITEM.equals(tagName)) {
                JSONObject itemData = this.parseDataItem(parser);
                this.mDataSaver.saveData(itemData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseTableFields(XmlPullParser parser) {
        String name = parser.getAttributeValue("", "name");
        String type = parser.getAttributeValue("", "type");
        boolean isPrimaryKey = Boolean.parseBoolean(parser.getAttributeValue("", "primary_key"));
        DataSyncField field = new DataSyncField();
        field.setName(name);
        field.setType(type);
        field.setPrimaryKey(isPrimaryKey);
        this.fields.add(field);
    }

    private JSONObject parseDataItem(XmlPullParser parser) {
        JSONObject result = null;
        try {
            int event = parser.nextTag();
            String name = parser.getName();
            result = new JSONObject();
            while (TAG_DATA_FIELD.equals(name) && event == 2) {
                String fieldName = parser.getAttributeValue("", TAG_FIELD);
                String fieldValue = parser.nextText();
                result.put(fieldName, (Object)fieldValue);
                parser.nextTag();
                name = parser.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public long getResponseTime() {
        return this.responseTime;
    }
}

