/*
 * Decompiled with CFR 0.152.
 */
package com.boanda.android.sync;

import android.text.TextUtils;
import android.util.Log;
import com.boanda.android.sync.ISyncJsonParser;
import com.boanda.android.sync.SyncDaoAdapter;
import com.google.gson.stream.JsonReader;
import com.szboanda.android.platform.util.FileUtils;
import com.szboanda.android.platform.util.JsonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.json.JSONArray;
import org.json.JSONObject;

public class SyncJsonParser
implements ISyncJsonParser {
    public static final String KEY_TABLE = "table";
    public static final String KEY_DATA_ARRAY = "data_array";
    private SyncDaoAdapter mDataSaver = null;

    @Override
    public boolean parseJson(File syncJsonFile) {
        this.mDataSaver = new SyncDaoAdapter();
        boolean isSuccess = false;
        if (syncJsonFile != null && syncJsonFile.exists()) {
            isSuccess = this.parseReadInWhole(syncJsonFile);
            this.mDataSaver.end();
        }
        return isSuccess;
    }

    private boolean parseReadInWhole(File syncFile) {
        boolean isSuccess = false;
        try {
            JSONObject data;
            String content = FileUtils.readContent((String)syncFile.getAbsolutePath());
            if (!TextUtils.isEmpty((CharSequence)content) && (data = JsonUtils.parseJsonObject((String)content)) != null) {
                String tableName = data.optString(KEY_TABLE);
                this.mDataSaver.setTableName(tableName);
                JSONArray dataArray = data.optJSONArray(KEY_DATA_ARRAY);
                if (dataArray != null) {
                    for (int i = 0; i < dataArray.length(); ++i) {
                        JSONObject item = dataArray.optJSONObject(i);
                        this.mDataSaver.saveData(item);
                    }
                }
                isSuccess = true;
            }
        }
        catch (Exception e) {
            Log.e((String)"SyncSaveError", (String)this.mDataSaver.getTableName());
            e.printStackTrace();
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseReadInStream(File syncFile) {
        boolean isSuccess = false;
        InputStreamReader streamReader = null;
        try {
            streamReader = new InputStreamReader((InputStream)new FileInputStream(syncFile), "utf-8");
            JsonReader reader = new JsonReader((Reader)streamReader);
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if (KEY_TABLE.equals(key)) {
                    String table = reader.nextString();
                    this.mDataSaver.setTableName(table);
                    continue;
                }
                this.beginArray(reader);
            }
            reader.endObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (streamReader != null) {
                    streamReader.close();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return isSuccess;
    }

    private void beginArray(JsonReader reader) {
        try {
            reader.beginArray();
            while (reader.hasNext()) {
                this.parseItemJson(reader);
            }
            reader.endArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseItemJson(JsonReader reader) {
        try {
            reader.beginObject();
            JSONObject item = new JSONObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                String value = reader.nextString();
                item.accumulate(key, (Object)value);
            }
            this.mDataSaver.saveData(item);
            reader.endObject();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

