/*
 * Decompiled with CFR 0.152.
 */
package com.boanda.android.sync;

import android.text.TextUtils;
import android.util.Xml;
import com.boanda.android.sync.DataSyncField;
import com.szboanda.android.platform.db.TableDao;
import com.szboanda.android.platform.util.FileUtils;
import com.szboanda.android.platform.util.JsonUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xmlpull.v1.XmlPullParser;

public class SyncFileParser {
    private static final String TAG_TABLE = "table";
    private static final String TAG_REP_TIME = "response-time";
    private static final String TAG_FIELD = "field";
    private static final String TAG_DATA_ITEM = "data-item";
    private static final String TAG_DATA_FIELD = "data-field";
    private String encode = "UTF-8";
    private String tableName = "";
    private long responseTime;
    private List<DataSyncField> fields = null;
    TableDao dao = null;

    public String getTableName() {
        return this.tableName;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public List<DataSyncField> getFields() {
        return this.fields;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = responseTime;
    }

    public void setFields(List<DataSyncField> fields) {
        this.fields = fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parse(File file) {
        boolean isSuccess;
        block19: {
            isSuccess = false;
            try {
                if (file == null || !file.exists()) break block19;
                XmlPullParser parser = Xml.newPullParser();
                InputStream input = null;
                try {
                    input = new BufferedInputStream(new FileInputStream(file));
                    parser.setInput(input, this.encode);
                    int eventType = parser.getEventType();
                    while (eventType != 1) {
                        switch (eventType) {
                            case 0: {
                                this.fields = new ArrayList<DataSyncField>();
                                break;
                            }
                            case 2: {
                                this.parseTag(parser);
                                break;
                            }
                        }
                        eventType = parser.next();
                    }
                    if (this.dao != null) {
                        this.dao.endTransaction();
                    }
                    isSuccess = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        input.close();
                        input = null;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isSuccess;
    }

    public boolean parseJsonFile(File file) {
        boolean isSuccess = false;
        try {
            JSONObject data;
            String content;
            if (file != null && file.exists() && !TextUtils.isEmpty((CharSequence)(content = FileUtils.readContent((String)file.getAbsolutePath()))) && (data = JsonUtils.parseJsonObject((String)content)) != null) {
                this.tableName = data.optString(TAG_TABLE);
                JSONArray dataArray = data.optJSONArray("data_array");
                if (dataArray != null) {
                    for (int i = 0; i < dataArray.length(); ++i) {
                        JSONObject item = dataArray.optJSONObject(i);
                        this.saveData(item);
                    }
                }
                if (this.dao != null) {
                    this.dao.endTransaction();
                }
                isSuccess = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isSuccess;
    }

    private void parseTag(XmlPullParser parser) {
        try {
            String tagName = parser.getName();
            if (TAG_TABLE.equals(tagName)) {
                this.tableName = parser.nextText();
            } else if (TAG_REP_TIME.equals(tagName)) {
                this.responseTime = Long.parseLong(parser.nextText());
            } else if (TAG_FIELD.equals(tagName)) {
                this.parseTableFields(parser);
            } else if (TAG_DATA_ITEM.equals(tagName)) {
                JSONObject itemData = this.parseDataItem(parser);
                this.saveData(itemData);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseTableFields(XmlPullParser parser) {
        String name = parser.getAttributeValue("", "name");
        String type = parser.getAttributeValue("", "type");
        boolean isPrimaryKey = Boolean.parseBoolean(parser.getAttributeValue("", "primary_key"));
        DataSyncField field = new DataSyncField();
        field.setName(name);
        field.setType(type);
        field.setPrimaryKey(isPrimaryKey);
        this.fields.add(field);
    }

    private JSONObject parseDataItem(XmlPullParser parser) {
        JSONObject result = null;
        try {
            int event = parser.nextTag();
            String name = parser.getName();
            result = new JSONObject();
            while (TAG_DATA_FIELD.equals(name) && event == 2) {
                String fieldName = parser.getAttributeValue("", TAG_FIELD);
                String fieldValue = parser.nextText();
                result.put(fieldName, (Object)fieldValue);
                parser.nextTag();
                name = parser.getName();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void saveData(JSONObject itemData) {
        if (this.dao == null) {
            this.dao = new TableDao(this.tableName);
            this.dao.beginTransaction();
        }
        this.dao.replaceData(itemData);
    }
}

