package com.boanda.android.sync;

import java.util.Date;

import org.xutils.db.annotation.Column;
import org.xutils.db.annotation.Table;

@Table(name="T_SUBMIT_ITEMS", onCreated = "CREATE UNIQUE INDEX T_SUBMIT_ITEMS_index ON T_SUBMIT_ITEMS (tab_name, pk_value)")
public class SyncSubmitItem {
	
	@Column(name = "id", isId = true)
	long id;
	
	/**表名.存储表对应的JavaBean的类全路径名称.
	 * 当同步的是文件时，总是存储字符串"file"标识是需要同步的是文件*/
	@Column(name="tab_name", property = "NOT NULL")
	String table;
	
	@Column(name="pk_value", property = "NOT NULL")
	String pkValue;
	
	@Column(name="submited")
	boolean isSubmited;
	
	String cjr;
	
	Date cjsj;
	
	String xgr;
	
	Date xgsj;
	
	String orgid;
	
	public long getId() {
		return id;
	}

	public void setId(long id) {
		this.id = id;
	}

	public String getTable() {
		return table;
	}

	public Object getPkValue() {
		return pkValue;
	}

	public boolean isSubmited() {
		return isSubmited;
	}

	public String getCjr() {
		return cjr;
	}

	public Date getCjsj() {
		return cjsj;
	}

	public String getXgr() {
		return xgr;
	}

	public Date getXgsj() {
		return xgsj;
	}

	public String getOrgid() {
		return orgid;
	}

	public void setTable(String table) {
		this.table = table;
	}

	public void setPkValue(String pkValue) {
		this.pkValue = pkValue;
	}

	public void setSubmited(boolean isSubmited) {
		this.isSubmited = isSubmited;
	}

	public void setCjr(String cjr) {
		this.cjr = cjr;
	}

	public void setCjsj(Date cjsj) {
		this.cjsj = cjsj;
	}

	public void setXgr(String xgr) {
		this.xgr = xgr;
	}

	public void setXgsj(Date xgsj) {
		this.xgsj = xgsj;
	}

	public void setOrgid(String orgid) {
		this.orgid = orgid;
	}
	
	

}
