package com.boanda.android.sync;

import android.text.TextUtils;

import org.xutils.http.app.InputStreamResponseParser;
import org.xutils.http.request.UriRequest;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * <p>Description: 同步响应处理器</p>
 * @author    Siyi Lu    Create Date: 2015-7-8
 */
public class SyncResponseProcessor extends InputStreamResponseParser{
	
	/**分割文件块的字符,使用8个#作为文件块的分隔符*/
	private final static String DEPART_FILE_SINGLES = "########";
	
	private String syncFilePath = "/response/";
	
	private List<File> mSyncDataFiles = null;
	
	private boolean isJsonSupport = false;

    @Override
    public Object parse(Type type, Class<?> aClass, InputStream inputStream) throws Throwable {
        process(inputStream);
        return new DataSyncResponse(this);
    }

    @Override
    public void checkResponse(UriRequest uriRequest) throws Throwable {}

    public void process(InputStream inputStream){
		//保存同步数据文件
		saveSyncDataFile(inputStream);
		//解析并保存、更新数据
		parseFileAndSave();
	}
	
	/**
	 * 存储同步数据文件
     * @param is 网络连接{@link HttpURLConnection#getInputStream()}，因为xUtils中请求完成后都会执行
     *           该读数据流的关闭操作，在使用完该数据流后，不需要关闭它
	 * @return
	 */
	private void saveSyncDataFile(InputStream is){
		mSyncDataFiles = new ArrayList<File>();
		if(is != null){
			File dir = new File(DataSyncManager.getInstance().getCachePath() + syncFilePath);
			if(!dir.exists()){
				dir.mkdirs();
			}
			BufferedReader reader = null;
			PrintWriter writer = null;
			try{
				File syncFile = createSyncFile(dir.getAbsolutePath());
				mSyncDataFiles.add(syncFile);
				reader = new BufferedReader(new InputStreamReader(is));
				writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(syncFile)));
				String readContent = "";
				while ((readContent = reader.readLine()) != null) {
					if(DEPART_FILE_SINGLES.equals(readContent)){
						//关闭上一个文件
						writer.flush();
						writer.close();    
						writer = null;
						syncFile = createSyncFile(dir.getAbsolutePath());
						mSyncDataFiles.add(syncFile);
						writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(syncFile)));
					}else{
						//需要判断是否为空，防止文件头出现开始行出现空行
						if(!TextUtils.isEmpty(readContent)){
							writer.println(readContent);
							isJsonSupport = isJsonSupport || readContent.trim().startsWith("{");
						}
					}
				}
			}catch (Exception e) {
				e.printStackTrace();
			}finally{
				try{
					if(writer != null){
						writer.flush();
						writer.close();
					}
				}catch(Exception e){
					e.printStackTrace();
				}
			}
		}
	}
	
	/**
	 * 创建同步数据的文件
	 * @param dir
	 * @return
	 */
	private File createSyncFile(String dir){
		String name = dir+ "/" + UUID.randomUUID().toString() + ".sync";
		File syncFile = new File(name);
		try{
			syncFile.createNewFile();
		}catch (Exception e) {
			e.printStackTrace();
		}
		return syncFile;
	}
	
	/**解析文件并保存数据*/
	private void parseFileAndSave(){
		for (File f : mSyncDataFiles) {
			HybridSyncParser parser = null;
			boolean isSuccess = false;
			if(isJsonSupport){
				parser = new HybridSyncParser(new SyncJsonParser());
				isSuccess = parser.parseJson(f);
			}else{
				parser = new HybridSyncParser(new SyncXmlParser());
				isSuccess = parser.parseXml(f);
			}
			if(isSuccess){
				f.delete();
			}
		}
	}
}
