package com.boanda.android.sync;

import android.util.Log;

import org.json.JSONObject;

import com.szboanda.android.platform.db.TableDao;

public class SyncDaoAdapter {
	
	private String mTableName;
	
	private TableDao mTableDao;
	
	public void setTableName(String tableName){
		mTableName = tableName;
	}
	
	public void saveData(JSONObject item){
		if(mTableDao == null){
			mTableDao = new TableDao(mTableName);
			mTableDao.beginTransaction();
		}
		mTableDao.replaceData(item);
	}
	
	public void end(){
		if(mTableDao != null){
			mTableDao.endTransaction();
		}
	}

    public String getTableName() {
        return mTableName;
    }
}
